/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.StreamMessage;
import org.mockejb.jms.MessageImpl;

public class StreamMessageImpl
extends MessageImpl
implements StreamMessage {
    private final List streamData = new ArrayList();
    private int position;
    private int byteArrayPosition;

    public StreamMessageImpl() {
    }

    public StreamMessageImpl(StreamMessage msg) throws JMSException {
        super((Message)msg);
        this.setBody(msg);
    }

    private void setBody(StreamMessage msg) throws JMSException {
        int elementsRemaining = 0;
        try {
            while (true) {
                msg.readObject();
                ++elementsRemaining;
            }
        }
        catch (MessageEOFException ex) {
            this.extractElements(msg);
            msg.reset();
            int moveTo = this.streamData.size() - elementsRemaining;
            while (moveTo-- > 0) {
                msg.readObject();
            }
        }
        catch (MessageNotReadableException ex) {
            this.extractElements(msg);
            msg.clearBody();
            for (int i = 0; i < this.streamData.size(); ++i) {
                msg.writeObject(this.streamData.get(i));
            }
        }
    }

    private void extractElements(StreamMessage msg) throws JMSException {
        msg.reset();
        try {
            while (true) {
                this.writeObject(msg.readObject());
            }
        }
        catch (MessageEOFException ex) {
            return;
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.streamData.clear();
    }

    /*
     * WARNING - void declaration
     */
    public boolean readBoolean() throws JMSException {
        void var2_2;
        boolean result;
        this.checkBodyReadable();
        this.checkEOF();
        Object value = this.streamData.get(this.position);
        if (value instanceof Boolean) {
            result = (Boolean)value;
        } else if (value == null || value instanceof String) {
            result = Boolean.valueOf((String)value);
        } else {
            throw new MessageFormatException("Current position does not contain valid Boolean value!");
        }
        ++this.position;
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public byte readByte() throws JMSException {
        void var2_2;
        byte result;
        this.checkBodyReadable();
        this.checkEOF();
        Object value = this.streamData.get(this.position);
        if (value instanceof Byte) {
            result = (Byte)value;
        } else if (value == null || value instanceof String) {
            result = Byte.valueOf((String)value);
        } else {
            throw new MessageFormatException("Current position does not contain valid Byte value!");
        }
        ++this.position;
        return (byte)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public short readShort() throws JMSException {
        void var2_2;
        short result;
        this.checkBodyReadable();
        this.checkEOF();
        Object value = this.streamData.get(this.position);
        if (value instanceof Byte || value instanceof Short) {
            result = ((Number)value).shortValue();
        } else if (value == null || value instanceof String) {
            result = Short.valueOf((String)value);
        } else {
            throw new MessageFormatException("Current position does not contain valid Short value!");
        }
        ++this.position;
        return (short)var2_2;
    }

    public char readChar() throws JMSException {
        this.checkBodyReadable();
        this.checkEOF();
        Object value = this.streamData.get(this.position);
        if (value == null) {
            throw new NullPointerException();
        }
        if (!(value instanceof Character)) {
            throw new MessageFormatException("Current position does not contain valid Char value!");
        }
        char result = ((Character)value).charValue();
        ++this.position;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public int readInt() throws JMSException {
        void var2_2;
        int result;
        this.checkBodyReadable();
        this.checkEOF();
        Object value = this.streamData.get(this.position);
        if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            result = ((Number)value).intValue();
        } else if (value == null || value instanceof String) {
            result = Integer.valueOf((String)value);
        } else {
            throw new MessageFormatException("Current position does not contain valid Integer value!");
        }
        ++this.position;
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public long readLong() throws JMSException {
        void var2_2;
        long result;
        this.checkBodyReadable();
        this.checkEOF();
        Object value = this.streamData.get(this.position);
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            result = ((Number)value).longValue();
        } else if (value == null || value instanceof String) {
            result = Long.valueOf((String)value);
        } else {
            throw new MessageFormatException("Current position does not contain valid Long value!");
        }
        ++this.position;
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public float readFloat() throws JMSException {
        void var2_2;
        float result;
        this.checkBodyReadable();
        this.checkEOF();
        Object value = this.streamData.get(this.position);
        if (value instanceof Float) {
            result = ((Float)value).floatValue();
        } else if (value == null || value instanceof String) {
            result = Float.valueOf((String)value).floatValue();
        } else {
            throw new MessageFormatException("Current position does not contain valid Float value!");
        }
        ++this.position;
        return (float)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public double readDouble() throws JMSException {
        void var2_2;
        double result;
        this.checkBodyReadable();
        this.checkEOF();
        Object value = this.streamData.get(this.position);
        if (value instanceof Float || value instanceof Double) {
            result = ((Number)value).doubleValue();
        } else if (value == null || value instanceof String) {
            result = Double.valueOf((String)value);
        } else {
            throw new MessageFormatException("Current position does not contain valid Double value!");
        }
        ++this.position;
        return (double)var2_2;
    }

    public String readString() throws JMSException {
        this.checkBodyReadable();
        this.checkEOF();
        Object value = this.streamData.get(this.position);
        if (value instanceof byte[]) {
            throw new MessageFormatException("Current position does not contain valid UTF value!");
        }
        ++this.position;
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public int readBytes(byte[] bytes) throws JMSException {
        int numOfBytesToCopy;
        this.checkBodyReadable();
        this.checkEOF();
        if (bytes == null) {
            throw new NullPointerException();
        }
        Object value = this.streamData.get(this.position);
        if (this.byteArrayPosition == -1 || value == null) {
            ++this.position;
            this.byteArrayPosition = 0;
            return -1;
        }
        if (!(value instanceof byte[])) {
            throw new MessageFormatException("Current position does not contain valid byte[] value!");
        }
        byte[] byteArray = (byte[])value;
        if (byteArray.length == 0) {
            this.byteArrayPosition = -1;
            return 0;
        }
        int remainingBytesToCopy = byteArray.length - this.byteArrayPosition;
        int startOffset = this.byteArrayPosition;
        if (remainingBytesToCopy <= bytes.length) {
            numOfBytesToCopy = remainingBytesToCopy;
            this.byteArrayPosition = -1;
        } else {
            numOfBytesToCopy = bytes.length;
            this.byteArrayPosition += numOfBytesToCopy;
        }
        int i = 0;
        for (int j = numOfBytesToCopy; j > 0; --j) {
            bytes[i++] = byteArray[startOffset++];
        }
        return numOfBytesToCopy;
    }

    public Object readObject() throws JMSException {
        this.checkBodyReadable();
        this.checkEOF();
        Object result = this.streamData.get(this.position++);
        if (result instanceof byte[]) {
            result = ((byte[])result).clone();
        }
        return result;
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkBodyWriteable();
        this.streamData.add(new Boolean(value));
    }

    public void writeByte(byte value) throws JMSException {
        this.checkBodyWriteable();
        this.streamData.add(new Byte(value));
    }

    public void writeShort(short value) throws JMSException {
        this.checkBodyWriteable();
        this.streamData.add(new Short(value));
    }

    public void writeChar(char value) throws JMSException {
        this.checkBodyWriteable();
        this.streamData.add(new Character(value));
    }

    public void writeInt(int value) throws JMSException {
        this.checkBodyWriteable();
        this.streamData.add(new Integer(value));
    }

    public void writeLong(long value) throws JMSException {
        this.checkBodyWriteable();
        this.streamData.add(new Long(value));
    }

    public void writeFloat(float value) throws JMSException {
        this.checkBodyWriteable();
        this.streamData.add(new Float(value));
    }

    public void writeDouble(double value) throws JMSException {
        this.checkBodyWriteable();
        this.streamData.add(new Double(value));
    }

    public void writeString(String value) throws JMSException {
        this.checkBodyWriteable();
        this.streamData.add(value);
    }

    public void writeBytes(byte[] bytes) throws JMSException {
        this.checkBodyWriteable();
        if (bytes == null) {
            this.streamData.add(null);
            return;
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws JMSException {
        this.checkBodyWriteable();
        if (bytes == null) {
            this.streamData.add(null);
            return;
        }
        if (offset < 0 || length < 0 || offset + length > bytes.length) {
            throw new IllegalArgumentException();
        }
        byte[] bytesToAdd = new byte[length];
        int i = 0;
        while (i < length) {
            bytesToAdd[i++] = bytes[offset++];
        }
        this.streamData.add(bytesToAdd);
    }

    public void writeObject(Object value) throws JMSException {
        this.checkBodyWriteable();
        if (!(value == null || value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Character || value instanceof byte[])) {
            throw new MessageFormatException("Incorrect object type!");
        }
        if (value instanceof byte[]) {
            value = ((byte[])value).clone();
        }
        this.streamData.add(value);
    }

    public void reset() throws JMSException {
        this.setBodyReadOnly();
        this.position = 0;
        this.byteArrayPosition = 0;
    }

    private void checkEOF() throws MessageEOFException {
        if (this.position >= this.streamData.size()) {
            throw new MessageEOFException("EOF reached!");
        }
    }

    Object[] getStreamData() {
        return this.streamData.toArray();
    }

    void resetBody() throws JMSException {
        this.reset();
    }
}

