/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.mockejb.MethodNotImplementedException;
import org.mockejb.jms.BytesMessageImpl;
import org.mockejb.jms.MapMessageImpl;
import org.mockejb.jms.MessageImpl;
import org.mockejb.jms.MockConnection;
import org.mockejb.jms.MockConsumer;
import org.mockejb.jms.MockDestination;
import org.mockejb.jms.MockProducer;
import org.mockejb.jms.ObjectMessageImpl;
import org.mockejb.jms.StreamMessageImpl;
import org.mockejb.jms.TextMessageImpl;

abstract class MockSession
implements Session {
    private boolean closed = false;
    private boolean transacted;
    private int acknowledgeMode;
    private MockConnection connection;
    private final List consumers = new ArrayList();
    private final List producers = new ArrayList();

    public MockSession(boolean transacted, int acknowledgeMode, MockConnection connection) {
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.connection = connection;
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.acknowledgeMode;
    }

    public void close() throws JMSException {
        this.closed = true;
        Iterator it = this.consumers.iterator();
        while (it.hasNext()) {
            ((MockConsumer)it.next()).close();
        }
        it = this.producers.iterator();
        while (it.hasNext()) {
            ((MockProducer)it.next()).close();
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Can not invoke methods on closed session!");
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return new BytesMessageImpl();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        return new MessageImpl();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        return new ObjectMessageImpl(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return new StreamMessageImpl();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        return new TextMessageImpl(text);
    }

    public void commit() throws JMSException {
        throw new MethodNotImplementedException("commit", "MockSession");
    }

    public void rollback() throws JMSException {
        throw new MethodNotImplementedException("rollback", "MockSession");
    }

    public void recover() throws JMSException {
        throw new MethodNotImplementedException("recover", "MockSession");
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new MethodNotImplementedException("getMessageListener", "MockSession");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new MethodNotImplementedException("setMessageListener", "MockSession");
    }

    public void run() {
        throw new MethodNotImplementedException("run", "MockSession");
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkClosed();
        if (destination instanceof MockDestination) {
            MockDestination dest = (MockDestination)destination;
            MockConsumer consumer = this.createMockConsumer(dest);
            dest.registerConsumer(consumer);
            this.consumers.add(consumer);
            return consumer;
        }
        throw new InvalidDestinationException("Unsupported destination!");
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        throw new MethodNotImplementedException("createConsumer", "MockSession");
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        throw new MethodNotImplementedException("createConsumer", "MockSession");
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        if (destination instanceof MockDestination) {
            MockProducer result = this.createMockProducer((MockDestination)destination);
            this.producers.add(result);
            return result;
        }
        throw new InvalidDestinationException("Unsupported destination!");
    }

    abstract MockConsumer createMockConsumer(MockDestination var1) throws JMSException;

    abstract MockProducer createMockProducer(MockDestination var1) throws JMSException;

    MockConnection getConnection() {
        return this.connection;
    }

    void consumeMessages() throws JMSException {
        Iterator it = this.consumers.iterator();
        while (it.hasNext()) {
            ((MockConsumer)it.next()).consume();
        }
    }
}

