/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.MockRequestDispatcher;
import com.mockrunner.mock.web.MockServletContext;
import com.mockrunner.mock.web.MockServletInputStream;
import com.mockrunner.util.common.CaseAwareMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MockHttpServletRequest
implements HttpServletRequest {
    private Map attributes;
    private Map parameters;
    private Vector locales;
    private Map requestDispatchers;
    private HttpSession session;
    private String method;
    private String authType;
    private Map headers;
    private String contextPath;
    private String pathInfo;
    private String pathTranslated;
    private String queryString;
    private StringBuffer requestUrl;
    private String requestUri;
    private String servletPath;
    private Principal principal;
    private String remoteUser;
    private boolean requestedSessionIdIsFromCookie;
    private String protocol;
    private String serverName;
    private int serverPort;
    private String scheme;
    private String remoteHost;
    private String remoteAddr;
    private Map roles;
    private String characterEncoding;
    private int contentLength;
    private String contentType;
    private List cookies;
    private MockServletInputStream bodyContent;
    private String localAddr;
    private String localName;
    private int localPort;
    private int remotePort;
    private boolean sessionCreated;
    private List attributeListener;

    public MockHttpServletRequest() {
        this.resetAll();
    }

    public void resetAll() {
        this.attributes = new HashMap();
        this.parameters = new HashMap();
        this.locales = new Vector();
        this.requestDispatchers = new HashMap();
        this.method = "GET";
        this.headers = new CaseAwareMap();
        this.requestedSessionIdIsFromCookie = true;
        this.protocol = "HTTP/1.1";
        this.serverName = "localhost";
        this.serverPort = 8080;
        this.scheme = "http";
        this.remoteHost = "localhost";
        this.remoteAddr = "127.0.0.1";
        this.roles = new HashMap();
        this.contentLength = -1;
        this.cookies = null;
        this.localAddr = "127.0.0.1";
        this.localName = "localhost";
        this.localPort = 8080;
        this.remotePort = 5000;
        this.sessionCreated = false;
        this.attributeListener = new ArrayList();
        this.bodyContent = new MockServletInputStream(new byte[0]);
    }

    public void addAttributeListener(ServletRequestAttributeListener servletRequestAttributeListener) {
        this.attributeListener.add(servletRequestAttributeListener);
    }

    public String getParameter(String string) {
        String[] stringArray = this.getParameterValues(string);
        if (null != stringArray && 0 < stringArray.length) {
            return stringArray[0];
        }
        return null;
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public String[] getParameterValues(String string) {
        return (String[])this.parameters.get(string);
    }

    public void setupAddParameter(String string, String[] stringArray) {
        this.parameters.put(string, stringArray);
    }

    public void setupAddParameter(String string, String string2) {
        this.setupAddParameter(string, new String[]{string2});
    }

    public Enumeration getParameterNames() {
        Vector vector = new Vector(this.parameters.keySet());
        return vector.elements();
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Enumeration getAttributeNames() {
        Vector vector = new Vector(this.attributes.keySet());
        return vector.elements();
    }

    public void removeAttribute(String string) {
        Object v = this.attributes.get(string);
        this.attributes.remove(string);
        if (null != v) {
            this.callAttributeListenersRemovedMethod(string, v);
        }
    }

    public void setAttribute(String string, Object object) {
        Object v = this.attributes.get(string);
        if (null == object) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
        this.handleAttributeListenerCalls(string, object, v);
    }

    public HttpSession getSession() {
        this.sessionCreated = true;
        return this.session;
    }

    public HttpSession getSession(boolean bl) {
        if (!bl && !this.sessionCreated) {
            return null;
        }
        return this.getSession();
    }

    public void setSession(HttpSession httpSession) {
        this.session = httpSession;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        RequestDispatcher requestDispatcher = (RequestDispatcher)this.requestDispatchers.get(string);
        if (null == requestDispatcher) {
            requestDispatcher = new MockRequestDispatcher();
            this.setRequestDispatcher(string, requestDispatcher);
        }
        return requestDispatcher;
    }

    public Map getRequestDispatcherMap() {
        return Collections.unmodifiableMap(this.requestDispatchers);
    }

    public void clearRequestDispatcherMap() {
        this.requestDispatchers.clear();
    }

    public void setRequestDispatcher(String string, RequestDispatcher requestDispatcher) {
        if (requestDispatcher instanceof MockRequestDispatcher) {
            ((MockRequestDispatcher)requestDispatcher).setPath(string);
        }
        this.requestDispatchers.put(string, requestDispatcher);
    }

    public Locale getLocale() {
        if (this.locales.size() < 1) {
            return Locale.getDefault();
        }
        return (Locale)this.locales.get(0);
    }

    public Enumeration getLocales() {
        return this.locales.elements();
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addLocales(List list) {
        this.locales.addAll(list);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String string) {
        this.authType = string;
    }

    public long getDateHeader(String string) {
        String string2 = this.getHeader(string);
        if (null == string2) {
            return -1L;
        }
        try {
            Date date = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US).parse(string2);
            return date.getTime();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage());
        }
    }

    public String getHeader(String string) {
        List list = (List)this.headers.get(string);
        if (null == list || 0 == list.size()) {
            return null;
        }
        return (String)list.get(0);
    }

    public Enumeration getHeaderNames() {
        return new Vector(this.headers.keySet()).elements();
    }

    public Enumeration getHeaders(String string) {
        List list = (List)this.headers.get(string);
        if (null == list) {
            return null;
        }
        return new Vector(list).elements();
    }

    public int getIntHeader(String string) {
        String string2 = this.getHeader(string);
        if (null == string2) {
            return -1;
        }
        return new Integer(string2);
    }

    public void addHeader(String string, String string2) {
        ArrayList<String> arrayList = (ArrayList<String>)this.headers.get(string);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            this.headers.put(string, arrayList);
        }
        arrayList.add(string2);
    }

    public void setHeader(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.headers.put(string, arrayList);
        arrayList.add(string2);
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String string) {
        this.pathInfo = string;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public void setPathTranslated(String string) {
        this.pathTranslated = string;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public String getRequestURI() {
        return this.requestUri;
    }

    public void setRequestURI(String string) {
        this.requestUri = string;
    }

    public StringBuffer getRequestURL() {
        return this.requestUrl;
    }

    public void setRequestURL(String string) {
        this.requestUrl = new StringBuffer(string);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String string) {
        this.servletPath = string;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String string) {
        this.remoteUser = string;
    }

    public Cookie[] getCookies() {
        if (null == this.cookies) {
            return null;
        }
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public void addCookie(Cookie cookie) {
        if (null == this.cookies) {
            this.cookies = new ArrayList();
        }
        this.cookies.add(cookie);
    }

    public String getRequestedSessionId() {
        HttpSession httpSession = this.getSession();
        if (null == httpSession) {
            return null;
        }
        return httpSession.getId();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdIsFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return !this.requestedSessionIdIsFromCookie;
    }

    public void setRequestedSessionIdFromCookie(boolean bl) {
        this.requestedSessionIdIsFromCookie = bl;
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession httpSession = this.getSession();
        return null != httpSession;
    }

    public boolean isUserInRole(String string) {
        if (!this.roles.containsKey(string)) {
            return false;
        }
        return (Boolean)this.roles.get(string);
    }

    public void setUserInRole(String string, boolean bl) {
        this.roles.put(string, new Boolean(bl));
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        this.characterEncoding = string;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int n) {
        this.contentLength = n;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int n) {
        this.serverPort = n;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String string) {
        this.scheme = string;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String string) {
        this.remoteAddr = string;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)((Object)this.bodyContent)));
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.bodyContent;
    }

    public void setBodyContent(byte[] byArray) {
        this.bodyContent = new MockServletInputStream(byArray);
    }

    public void setBodyContent(String string) {
        String string2 = null == this.characterEncoding ? "ISO-8859-1" : this.characterEncoding;
        try {
            this.setBodyContent(string.getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NestedApplicationException(unsupportedEncodingException);
        }
    }

    public String getRealPath(String string) {
        HttpSession httpSession = this.getSession();
        if (null == httpSession) {
            return null;
        }
        return httpSession.getServletContext().getRealPath(string);
    }

    public boolean isSecure() {
        String string = this.getScheme();
        if (null == string) {
            return false;
        }
        return string.equals("https");
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String string) {
        this.localAddr = string;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int n) {
        this.localPort = n;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int n) {
        this.remotePort = n;
    }

    private void handleAttributeListenerCalls(String string, Object object, Object object2) {
        if (null != object2) {
            if (object != null) {
                this.callAttributeListenersReplacedMethod(string, object2);
            } else {
                this.callAttributeListenersRemovedMethod(string, object2);
            }
        } else if (object != null) {
            this.callAttributeListenersAddedMethod(string, object);
        }
    }

    private void callAttributeListenersAddedMethod(String string, Object object) {
        for (int i = 0; i < this.attributeListener.size(); ++i) {
            ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, string, object);
            ((ServletRequestAttributeListener)this.attributeListener.get(i)).attributeAdded(servletRequestAttributeEvent);
        }
    }

    private void callAttributeListenersReplacedMethod(String string, Object object) {
        for (int i = 0; i < this.attributeListener.size(); ++i) {
            ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, string, object);
            ((ServletRequestAttributeListener)this.attributeListener.get(i)).attributeReplaced(servletRequestAttributeEvent);
        }
    }

    private void callAttributeListenersRemovedMethod(String string, Object object) {
        for (int i = 0; i < this.attributeListener.size(); ++i) {
            ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, string, object);
            ((ServletRequestAttributeListener)this.attributeListener.get(i)).attributeRemoved(servletRequestAttributeEvent);
        }
    }

    private ServletContext getServletContext() {
        if (null == this.session) {
            return new MockServletContext();
        }
        return this.session.getServletContext();
    }
}

