/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.jms.ConfigurationManager;
import com.mockrunner.jms.DestinationManager;
import com.mockrunner.jms.MessageManager;
import com.mockrunner.jms.QueueTransmissionManager;
import com.mockrunner.jms.TopicTransmissionManager;
import com.mockrunner.jms.TransmissionManagerWrapper;
import com.mockrunner.mock.jms.JMSMockObjectFactory;
import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockMessage;
import com.mockrunner.mock.jms.MockMessageConsumer;
import com.mockrunner.mock.jms.MockMessageProducer;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockQueueBrowser;
import com.mockrunner.mock.jms.MockQueueConnection;
import com.mockrunner.mock.jms.MockQueueConnectionFactory;
import com.mockrunner.mock.jms.MockQueueReceiver;
import com.mockrunner.mock.jms.MockQueueSender;
import com.mockrunner.mock.jms.MockQueueSession;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTemporaryQueue;
import com.mockrunner.mock.jms.MockTemporaryTopic;
import com.mockrunner.mock.jms.MockTopic;
import com.mockrunner.mock.jms.MockTopicConnection;
import com.mockrunner.mock.jms.MockTopicConnectionFactory;
import com.mockrunner.mock.jms.MockTopicPublisher;
import com.mockrunner.mock.jms.MockTopicSession;
import com.mockrunner.mock.jms.MockTopicSubscriber;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class JMSTestModule {
    private JMSMockObjectFactory mockFactory;
    private int currentQueueConnectionIndex;
    private int currentTopicConnectionIndex;
    private int currentConnectionIndex;

    public JMSTestModule(JMSMockObjectFactory jMSMockObjectFactory) {
        this.mockFactory = jMSMockObjectFactory;
        this.currentQueueConnectionIndex = -1;
        this.currentTopicConnectionIndex = -1;
        this.currentConnectionIndex = -1;
    }

    public void setCurrentQueueConnectionIndex(int n) {
        this.currentQueueConnectionIndex = n;
    }

    public MockQueueConnection getCurrentQueueConnection() {
        if (0 > this.currentQueueConnectionIndex) {
            return this.mockFactory.getMockQueueConnectionFactory().getLatestQueueConnection();
        }
        return this.mockFactory.getMockQueueConnectionFactory().getQueueConnection(this.currentQueueConnectionIndex);
    }

    public void setCurrentTopicConnectionIndex(int n) {
        this.currentTopicConnectionIndex = n;
    }

    public MockTopicConnection getCurrentTopicConnection() {
        if (0 > this.currentTopicConnectionIndex) {
            return this.mockFactory.getMockTopicConnectionFactory().getLatestTopicConnection();
        }
        return this.mockFactory.getMockTopicConnectionFactory().getTopicConnection(this.currentTopicConnectionIndex);
    }

    public void setCurrentConnectionIndex(int n) {
        this.currentConnectionIndex = n;
    }

    public MockConnection getCurrentConnection() {
        if (0 > this.currentConnectionIndex) {
            return this.mockFactory.getMockConnectionFactory().getLatestConnection();
        }
        return this.mockFactory.getMockConnectionFactory().getConnection(this.currentConnectionIndex);
    }

    public void registerTestMessageListenerForQueue(String string, MessageListener messageListener) {
        try {
            MockQueueConnectionFactory mockQueueConnectionFactory = this.mockFactory.getMockQueueConnectionFactory();
            MockQueueConnection mockQueueConnection = (MockQueueConnection)mockQueueConnectionFactory.createQueueConnection();
            this.registerTestMessageListenerForQueue(mockQueueConnection, string, messageListener);
        }
        catch (JMSException jMSException) {
            throw new NestedApplicationException(jMSException);
        }
    }

    public void registerTestMessageListenerForQueue(MockConnection mockConnection, String string, MessageListener messageListener) {
        this.registerTestMessageListenerForQueue(mockConnection, string, true, 1, messageListener);
    }

    public void registerTestMessageListenerForQueue(MockConnection mockConnection, String string, boolean bl, int n, MessageListener messageListener) {
        this.registerTestMessageListenerForQueue(mockConnection, string, bl, n, null, messageListener);
    }

    public void registerTestMessageListenerForQueue(MockConnection mockConnection, String string, boolean bl, int n, String string2, MessageListener messageListener) {
        try {
            MockQueue mockQueue = this.getDestinationManager().getQueue(string);
            MockSession mockSession = (MockSession)mockConnection.createSession(bl, n);
            MessageConsumer messageConsumer = mockSession.createConsumer(mockQueue, string2);
            messageConsumer.setMessageListener(messageListener);
            mockConnection.start();
        }
        catch (JMSException jMSException) {
            throw new NestedApplicationException(jMSException);
        }
    }

    public void registerTestMessageListenerForTopic(String string, MessageListener messageListener) {
        try {
            MockTopicConnectionFactory mockTopicConnectionFactory = this.mockFactory.getMockTopicConnectionFactory();
            MockTopicConnection mockTopicConnection = (MockTopicConnection)mockTopicConnectionFactory.createTopicConnection();
            this.registerTestMessageListenerForTopic(mockTopicConnection, string, messageListener);
        }
        catch (JMSException jMSException) {
            throw new NestedApplicationException(jMSException);
        }
    }

    public void registerTestMessageListenerForTopic(MockConnection mockConnection, String string, MessageListener messageListener) {
        this.registerTestMessageListenerForTopic(mockConnection, string, true, 1, messageListener);
    }

    public void registerTestMessageListenerForTopic(MockConnection mockConnection, String string, boolean bl, int n, MessageListener messageListener) {
        this.registerTestMessageListenerForTopic(mockConnection, string, bl, n, null, messageListener);
    }

    public void registerTestMessageListenerForTopic(MockConnection mockConnection, String string, boolean bl, int n, String string2, MessageListener messageListener) {
        try {
            MockTopic mockTopic = this.getDestinationManager().getTopic(string);
            MockSession mockSession = (MockSession)mockConnection.createSession(bl, n);
            MessageConsumer messageConsumer = mockSession.createConsumer(mockTopic, string2);
            messageConsumer.setMessageListener(messageListener);
            mockConnection.start();
        }
        catch (JMSException jMSException) {
            throw new NestedApplicationException(jMSException);
        }
    }

    public DestinationManager getDestinationManager() {
        return this.mockFactory.getDestinationManager();
    }

    public ConfigurationManager getConfigurationManager() {
        return this.mockFactory.getConfigurationManager();
    }

    public MessageManager getQueueMessageManager(int n) {
        MockQueueSession mockQueueSession = this.getQueueSession(n);
        if (null == mockQueueSession) {
            return null;
        }
        return mockQueueSession.getMessageManager();
    }

    public MessageManager getTopicMessageManager(int n) {
        MockTopicSession mockTopicSession = this.getTopicSession(n);
        if (null == mockTopicSession) {
            return null;
        }
        return mockTopicSession.getMessageManager();
    }

    public MessageManager getMessageManager(int n) {
        MockSession mockSession = this.getSession(n);
        if (null == mockSession) {
            return null;
        }
        return mockSession.getMessageManager();
    }

    public QueueTransmissionManager getQueueTransmissionManager(int n) {
        MockQueueSession mockQueueSession = this.getQueueSession(n);
        if (null == mockQueueSession) {
            return null;
        }
        return mockQueueSession.getQueueTransmissionManager();
    }

    public TopicTransmissionManager getTopicTransmissionManager(int n) {
        MockTopicSession mockTopicSession = this.getTopicSession(n);
        if (null == mockTopicSession) {
            return null;
        }
        return mockTopicSession.getTopicTransmissionManager();
    }

    public TransmissionManagerWrapper getTransmissionManager(int n) {
        return this.getTransmissionManagerWrapper(n);
    }

    public TransmissionManagerWrapper getTransmissionManagerWrapper(int n) {
        MockSession mockSession = this.getSession(n);
        if (null == mockSession) {
            return null;
        }
        return mockSession.getTransmissionManagerWrapper();
    }

    public TransmissionManagerWrapper getQueueTransmissionManagerWrapper(int n) {
        MockQueueSession mockQueueSession = this.getQueueSession(n);
        if (null == mockQueueSession) {
            return null;
        }
        return mockQueueSession.getTransmissionManagerWrapper();
    }

    public TransmissionManagerWrapper getTopicTransmissionManagerWrapper(int n) {
        MockTopicSession mockTopicSession = this.getTopicSession(n);
        if (null == mockTopicSession) {
            return null;
        }
        return mockTopicSession.getTransmissionManagerWrapper();
    }

    public List getQueueSessionList() {
        if (null == this.getCurrentQueueConnection()) {
            return null;
        }
        return this.getCurrentQueueConnection().getQueueSessionList();
    }

    public List getTopicSessionList() {
        if (null == this.getCurrentTopicConnection()) {
            return null;
        }
        return this.getCurrentTopicConnection().getTopicSessionList();
    }

    public List getSessionList() {
        if (null == this.getCurrentConnection()) {
            return null;
        }
        return this.getCurrentConnection().getSessionList();
    }

    public MockQueueSession getQueueSession(int n) {
        if (null == this.getCurrentQueueConnection()) {
            return null;
        }
        return this.getCurrentQueueConnection().getQueueSession(n);
    }

    public MockTopicSession getTopicSession(int n) {
        if (null == this.getCurrentTopicConnection()) {
            return null;
        }
        return this.getCurrentTopicConnection().getTopicSession(n);
    }

    public MockSession getSession(int n) {
        if (null == this.getCurrentConnection()) {
            return null;
        }
        return this.getCurrentConnection().getSession(n);
    }

    public MockQueue getQueue(String string) {
        return this.getDestinationManager().getQueue(string);
    }

    public MockTopic getTopic(String string) {
        return this.getDestinationManager().getTopic(string);
    }

    public List getTemporaryQueueList(int n) {
        MockQueueSession mockQueueSession = this.getQueueSession(n);
        if (null == mockQueueSession) {
            return null;
        }
        return mockQueueSession.getTemporaryQueueList();
    }

    public List getTemporaryTopicList(int n) {
        MockTopicSession mockTopicSession = this.getTopicSession(n);
        if (null == mockTopicSession) {
            return null;
        }
        return mockTopicSession.getTemporaryTopicList();
    }

    public MockTemporaryQueue getTemporaryQueue(int n, int n2) {
        MockQueueSession mockQueueSession = this.getQueueSession(n);
        if (null == mockQueueSession) {
            return null;
        }
        return mockQueueSession.getTemporaryQueue(n2);
    }

    public MockTemporaryTopic getTemporaryTopic(int n, int n2) {
        MockTopicSession mockTopicSession = this.getTopicSession(n);
        if (null == mockTopicSession) {
            return null;
        }
        return mockTopicSession.getTemporaryTopic(n2);
    }

    public List getCurrentMessageListFromQueue(String string) {
        MockQueue mockQueue = this.getQueue(string);
        if (null == mockQueue) {
            return null;
        }
        return mockQueue.getCurrentMessageList();
    }

    public List getCurrentMessageListFromTemporaryQueue(int n, int n2) {
        MockTemporaryQueue mockTemporaryQueue = this.getTemporaryQueue(n, n2);
        if (null == mockTemporaryQueue) {
            return null;
        }
        return mockTemporaryQueue.getCurrentMessageList();
    }

    public List getReceivedMessageListFromQueue(String string) {
        MockQueue mockQueue = this.getQueue(string);
        if (null == mockQueue) {
            return null;
        }
        return mockQueue.getReceivedMessageList();
    }

    public List getReceivedMessageListFromTemporaryQueue(int n, int n2) {
        MockTemporaryQueue mockTemporaryQueue = this.getTemporaryQueue(n, n2);
        if (null == mockTemporaryQueue) {
            return null;
        }
        return mockTemporaryQueue.getReceivedMessageList();
    }

    public List getCurrentMessageListFromTopic(String string) {
        MockTopic mockTopic = this.getTopic(string);
        if (null == mockTopic) {
            return null;
        }
        return mockTopic.getCurrentMessageList();
    }

    public List getCurrentMessageListFromTemporaryTopic(int n, int n2) {
        MockTemporaryTopic mockTemporaryTopic = this.getTemporaryTopic(n, n2);
        if (null == mockTemporaryTopic) {
            return null;
        }
        return mockTemporaryTopic.getCurrentMessageList();
    }

    public List getReceivedMessageListFromTopic(String string) {
        MockTopic mockTopic = this.getTopic(string);
        if (null == mockTopic) {
            return null;
        }
        return mockTopic.getReceivedMessageList();
    }

    public List getReceivedMessageListFromTemporaryTopic(int n, int n2) {
        MockTemporaryTopic mockTemporaryTopic = this.getTemporaryTopic(n, n2);
        if (null == mockTemporaryTopic) {
            return null;
        }
        return mockTemporaryTopic.getReceivedMessageList();
    }

    public void verifyQueueConnectionClosed() {
        if (null == this.getCurrentQueueConnection()) {
            throw new VerifyFailedException("No QueueConnection present.");
        }
        if (!this.getCurrentQueueConnection().isClosed()) {
            throw new VerifyFailedException("QueueConnection is not closed.");
        }
    }

    public void verifyQueueConnectionStarted() {
        if (null == this.getCurrentQueueConnection()) {
            throw new VerifyFailedException("No QueueConnection present.");
        }
        if (!this.getCurrentQueueConnection().isStarted()) {
            throw new VerifyFailedException("QueueConnection is not started.");
        }
    }

    public void verifyQueueConnectionStopped() {
        if (null == this.getCurrentQueueConnection()) {
            throw new VerifyFailedException("No QueueConnection present.");
        }
        if (!this.getCurrentQueueConnection().isStopped()) {
            throw new VerifyFailedException("QueueConnection is not stopped.");
        }
    }

    public void verifyTopicConnectionClosed() {
        if (null == this.getCurrentTopicConnection()) {
            throw new VerifyFailedException("No TopicConnection present.");
        }
        if (!this.getCurrentTopicConnection().isClosed()) {
            throw new VerifyFailedException("TopicConnection is not closed.");
        }
    }

    public void verifyTopicConnectionStarted() {
        if (null == this.getCurrentTopicConnection()) {
            throw new VerifyFailedException("No TopicConnection present.");
        }
        if (!this.getCurrentTopicConnection().isStarted()) {
            throw new VerifyFailedException("TopicConnection is not started.");
        }
    }

    public void verifyTopicConnectionStopped() {
        if (null == this.getCurrentTopicConnection()) {
            throw new VerifyFailedException("No TopicConnection present.");
        }
        if (!this.getCurrentTopicConnection().isStopped()) {
            throw new VerifyFailedException("TopicConnection is not stopped.");
        }
    }

    public void verifyConnectionClosed() {
        if (null == this.getCurrentConnection()) {
            throw new VerifyFailedException("No Connection present.");
        }
        if (!this.getCurrentConnection().isClosed()) {
            throw new VerifyFailedException("Connection is not closed.");
        }
    }

    public void verifyConnectionStarted() {
        if (null == this.getCurrentConnection()) {
            throw new VerifyFailedException("No Connection present.");
        }
        if (!this.getCurrentConnection().isStarted()) {
            throw new VerifyFailedException("Connection is not started.");
        }
    }

    public void verifyConnectionStopped() {
        if (null == this.getCurrentConnection()) {
            throw new VerifyFailedException("No Connection present.");
        }
        if (!this.getCurrentConnection().isStopped()) {
            throw new VerifyFailedException("Connection is not stopped.");
        }
    }

    public void verifyQueueSessionClosed(int n) {
        MockQueueSession mockQueueSession = this.checkAndGetQueueSessionByIndex(n);
        if (!mockQueueSession.isClosed()) {
            throw new VerifyFailedException("QueueSession with index " + n + " is not closed.");
        }
    }

    public void verifyQueueSessionCommitted(int n) {
        MockQueueSession mockQueueSession = this.checkAndGetQueueSessionByIndex(n);
        if (!mockQueueSession.isCommitted()) {
            throw new VerifyFailedException("QueueSession is not committed.");
        }
    }

    public void verifyQueueSessionNotCommitted(int n) {
        MockQueueSession mockQueueSession = this.checkAndGetQueueSessionByIndex(n);
        if (mockQueueSession.isCommitted()) {
            throw new VerifyFailedException("QueueSession is committed.");
        }
    }

    public void verifyQueueSessionNumberCommits(int n, int n2) {
        MockQueueSession mockQueueSession = this.checkAndGetQueueSessionByIndex(n);
        if (n2 != mockQueueSession.getNumberCommits()) {
            throw new VerifyFailedException("QueueSession was commited " + mockQueueSession.getNumberCommits() + " times, expected " + n2 + " times");
        }
    }

    public void verifyQueueSessionRolledBack(int n) {
        MockQueueSession mockQueueSession = this.checkAndGetQueueSessionByIndex(n);
        if (!mockQueueSession.isRolledBack()) {
            throw new VerifyFailedException("QueueSession is not rolled back.");
        }
    }

    public void verifyQueueSessionNotRolledBack(int n) {
        MockQueueSession mockQueueSession = this.checkAndGetQueueSessionByIndex(n);
        if (mockQueueSession.isRolledBack()) {
            throw new VerifyFailedException("QueueSession is rolled back.");
        }
    }

    public void verifyQueueSessionNumberRollbacks(int n, int n2) {
        MockQueueSession mockQueueSession = this.checkAndGetQueueSessionByIndex(n);
        if (n2 != mockQueueSession.getNumberRollbacks()) {
            throw new VerifyFailedException("QueueSession was rolled back " + mockQueueSession.getNumberRollbacks() + " times, expected " + n2 + " times");
        }
    }

    public void verifyQueueSessionRecovered(int n) {
        MockQueueSession mockQueueSession = this.checkAndGetQueueSessionByIndex(n);
        if (!mockQueueSession.isRecovered()) {
            throw new VerifyFailedException("QueueSession is not recovered.");
        }
    }

    public void verifyQueueSessionNotRecovered(int n) {
        MockQueueSession mockQueueSession = this.checkAndGetQueueSessionByIndex(n);
        if (mockQueueSession.isRecovered()) {
            throw new VerifyFailedException("QueueSession is recovered.");
        }
    }

    public void verifyTopicSessionClosed(int n) {
        MockTopicSession mockTopicSession = this.checkAndGetTopicSessionByIndex(n);
        if (!mockTopicSession.isClosed()) {
            throw new VerifyFailedException("TopicSession with index " + n + " is not closed.");
        }
    }

    public void verifyTopicSessionCommitted(int n) {
        MockTopicSession mockTopicSession = this.checkAndGetTopicSessionByIndex(n);
        if (!mockTopicSession.isCommitted()) {
            throw new VerifyFailedException("TopicSession is not committed.");
        }
    }

    public void verifyTopicSessionNotCommitted(int n) {
        MockTopicSession mockTopicSession = this.checkAndGetTopicSessionByIndex(n);
        if (mockTopicSession.isCommitted()) {
            throw new VerifyFailedException("TopicSession is committed.");
        }
    }

    public void verifyTopicSessionNumberCommits(int n, int n2) {
        MockTopicSession mockTopicSession = this.checkAndGetTopicSessionByIndex(n);
        if (n2 != mockTopicSession.getNumberCommits()) {
            throw new VerifyFailedException("TopicSession was commited " + mockTopicSession.getNumberCommits() + " times, expected " + n2 + " times");
        }
    }

    public void verifyTopicSessionRolledBack(int n) {
        MockTopicSession mockTopicSession = this.checkAndGetTopicSessionByIndex(n);
        if (!mockTopicSession.isRolledBack()) {
            throw new VerifyFailedException("TopicSession is not rolled back.");
        }
    }

    public void verifyTopicSessionNotRolledBack(int n) {
        MockTopicSession mockTopicSession = this.checkAndGetTopicSessionByIndex(n);
        if (mockTopicSession.isRolledBack()) {
            throw new VerifyFailedException("TopicSession is rolled back.");
        }
    }

    public void verifyTopicSessionNumberRollbacks(int n, int n2) {
        MockTopicSession mockTopicSession = this.checkAndGetTopicSessionByIndex(n);
        if (n2 != mockTopicSession.getNumberRollbacks()) {
            throw new VerifyFailedException("TopicSession was rolled back " + mockTopicSession.getNumberRollbacks() + " times, expected " + n2 + " times");
        }
    }

    public void verifyTopicSessionRecovered(int n) {
        MockTopicSession mockTopicSession = this.checkAndGetTopicSessionByIndex(n);
        if (!mockTopicSession.isRecovered()) {
            throw new VerifyFailedException("TopicSession is not recovered.");
        }
    }

    public void verifyTopicSessionNotRecovered(int n) {
        MockTopicSession mockTopicSession = this.checkAndGetTopicSessionByIndex(n);
        if (mockTopicSession.isRecovered()) {
            throw new VerifyFailedException("TopicSession is recovered.");
        }
    }

    public void verifySessionClosed(int n) {
        MockSession mockSession = this.checkAndGetSessionByIndex(n);
        if (!mockSession.isClosed()) {
            throw new VerifyFailedException("Session with index " + n + " is not closed.");
        }
    }

    public void verifySessionCommitted(int n) {
        MockSession mockSession = this.checkAndGetSessionByIndex(n);
        if (!mockSession.isCommitted()) {
            throw new VerifyFailedException("Session is not committed.");
        }
    }

    public void verifySessionNotCommitted(int n) {
        MockSession mockSession = this.checkAndGetSessionByIndex(n);
        if (mockSession.isCommitted()) {
            throw new VerifyFailedException("Session is committed.");
        }
    }

    public void verifySessionNumberCommits(int n, int n2) {
        MockSession mockSession = this.checkAndGetSessionByIndex(n);
        if (n2 != mockSession.getNumberCommits()) {
            throw new VerifyFailedException("Session was commited " + mockSession.getNumberCommits() + " times, expected " + n2 + " times");
        }
    }

    public void verifySessionRolledBack(int n) {
        MockSession mockSession = this.checkAndGetSessionByIndex(n);
        if (!mockSession.isRolledBack()) {
            throw new VerifyFailedException("Session is not rolled back.");
        }
    }

    public void verifySessionNotRolledBack(int n) {
        MockSession mockSession = this.checkAndGetSessionByIndex(n);
        if (mockSession.isRolledBack()) {
            throw new VerifyFailedException("Session is rolled back.");
        }
    }

    public void verifySessionNumberRollbacks(int n, int n2) {
        MockSession mockSession = this.checkAndGetSessionByIndex(n);
        if (n2 != mockSession.getNumberRollbacks()) {
            throw new VerifyFailedException("Session was rolled back " + mockSession.getNumberRollbacks() + " times, expected " + n2 + " times");
        }
    }

    public void verifySessionRecovered(int n) {
        MockSession mockSession = this.checkAndGetSessionByIndex(n);
        if (!mockSession.isRecovered()) {
            throw new VerifyFailedException("Session is not recovered.");
        }
    }

    public void verifySessionNotRecovered(int n) {
        MockSession mockSession = this.checkAndGetSessionByIndex(n);
        if (mockSession.isRecovered()) {
            throw new VerifyFailedException("Session is recovered.");
        }
    }

    public void verifyAllQueueSessionsClosed() {
        List list = this.getQueueSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockQueueSession mockQueueSession = (MockQueueSession)list.get(i);
            if (mockQueueSession.isClosed()) continue;
            throw new VerifyFailedException("QueueSession with index " + i + " is not closed.");
        }
    }

    public void verifyAllQueueSessionsRecovered() {
        List list = this.getQueueSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockQueueSession mockQueueSession = (MockQueueSession)list.get(i);
            if (mockQueueSession.isRecovered()) continue;
            throw new VerifyFailedException("QueueSession with index " + i + " is not recovered.");
        }
    }

    public void verifyAllQueueSessionsCommitted() {
        List list = this.getQueueSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockQueueSession mockQueueSession = (MockQueueSession)list.get(i);
            if (mockQueueSession.isCommitted()) continue;
            throw new VerifyFailedException("QueueSession with index " + i + " is not committed.");
        }
    }

    public void verifyAllQueueSessionsRolledBack() {
        List list = this.getQueueSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockQueueSession mockQueueSession = (MockQueueSession)list.get(i);
            if (mockQueueSession.isRolledBack()) continue;
            throw new VerifyFailedException("QueueSession with index " + i + " is not rolled back.");
        }
    }

    public void verifyAllTopicSessionsClosed() {
        List list = this.getTopicSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockTopicSession mockTopicSession = (MockTopicSession)list.get(i);
            if (mockTopicSession.isClosed()) continue;
            throw new VerifyFailedException("TopicSession with index " + i + " is not closed.");
        }
    }

    public void verifyAllTopicSessionsRecovered() {
        List list = this.getTopicSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockTopicSession mockTopicSession = (MockTopicSession)list.get(i);
            if (mockTopicSession.isRecovered()) continue;
            throw new VerifyFailedException("TopicSession with index " + i + " is not recovered.");
        }
    }

    public void verifyAllTopicSessionsCommitted() {
        List list = this.getTopicSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockTopicSession mockTopicSession = (MockTopicSession)list.get(i);
            if (mockTopicSession.isCommitted()) continue;
            throw new VerifyFailedException("TopicSession with index " + i + " is not committed.");
        }
    }

    public void verifyAllTopicSessionsRolledBack() {
        List list = this.getTopicSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockTopicSession mockTopicSession = (MockTopicSession)list.get(i);
            if (mockTopicSession.isRolledBack()) continue;
            throw new VerifyFailedException("TopicSession with index " + i + " is not rolled back.");
        }
    }

    public void verifyAllSessionsClosed() {
        List list = this.getSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockSession mockSession = (MockSession)list.get(i);
            if (mockSession.isClosed()) continue;
            throw new VerifyFailedException("Session with index " + i + " is not closed.");
        }
    }

    public void verifyAllSessionsRecovered() {
        List list = this.getSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockSession mockSession = (MockSession)list.get(i);
            if (mockSession.isRecovered()) continue;
            throw new VerifyFailedException("Session with index " + i + " is not recovered.");
        }
    }

    public void verifyAllSessionsCommitted() {
        List list = this.getSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockSession mockSession = (MockSession)list.get(i);
            if (mockSession.isCommitted()) continue;
            throw new VerifyFailedException("Session with index " + i + " is not committed.");
        }
    }

    public void verifyAllSessionsRolledBack() {
        List list = this.getSessionList();
        if (null == list) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MockSession mockSession = (MockSession)list.get(i);
            if (mockSession.isRolledBack()) continue;
            throw new VerifyFailedException("Session with index " + i + " is not rolled back.");
        }
    }

    public void verifyNumberMessageProducers(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        TransmissionManagerWrapper transmissionManagerWrapper = this.getTransmissionManagerWrapper(n);
        if (n2 != transmissionManagerWrapper.getMessageProducerList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " producers, actually " + transmissionManagerWrapper.getMessageProducerList().size() + " producers present");
        }
    }

    public void verifyAllMessageProducersClosed(int n) {
        this.checkAndGetSessionByIndex(n);
        TransmissionManagerWrapper transmissionManagerWrapper = this.getTransmissionManagerWrapper(n);
        List list = transmissionManagerWrapper.getMessageProducerList();
        for (int i = 0; i < list.size(); ++i) {
            MockMessageProducer mockMessageProducer = (MockMessageProducer)list.get(i);
            if (mockMessageProducer.isClosed()) continue;
            throw new VerifyFailedException("MessageProducer with index " + i + " not closed.");
        }
    }

    public void verifyNumberQueueSenders(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        TransmissionManagerWrapper transmissionManagerWrapper = this.getQueueTransmissionManagerWrapper(n);
        if (n2 != transmissionManagerWrapper.getQueueSenderList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " senders, actually " + transmissionManagerWrapper.getQueueSenderList().size() + " senders present");
        }
    }

    public void verifyNumberQueueSenders(int n, String string, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        this.checkQueueByName(string);
        QueueTransmissionManager queueTransmissionManager = this.getQueueTransmissionManager(n);
        if (n2 != queueTransmissionManager.getQueueSenderList(string).size()) {
            throw new VerifyFailedException("Expected " + n2 + " senders for queue " + string + ", actually " + queueTransmissionManager.getQueueSenderList(string).size() + " senders present");
        }
    }

    public void verifyQueueSenderClosed(int n, String string, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        this.checkQueueByName(string);
        QueueTransmissionManager queueTransmissionManager = this.getQueueTransmissionManager(n);
        List list = queueTransmissionManager.getQueueSenderList(string);
        if (n2 >= list.size()) {
            throw new VerifyFailedException("QueueSender with index " + n2 + " is not present.");
        }
        MockQueueSender mockQueueSender = (MockQueueSender)list.get(n2);
        if (!mockQueueSender.isClosed()) {
            throw new VerifyFailedException("QueueSender of queue " + string + " with index " + n2 + " not closed.");
        }
    }

    public void verifyAllQueueSendersClosed(int n) {
        this.checkAndGetQueueSessionByIndex(n);
        TransmissionManagerWrapper transmissionManagerWrapper = this.getQueueTransmissionManagerWrapper(n);
        List list = transmissionManagerWrapper.getQueueSenderList();
        for (int i = 0; i < list.size(); ++i) {
            MockQueueSender mockQueueSender = (MockQueueSender)list.get(i);
            if (mockQueueSender.isClosed()) continue;
            throw new VerifyFailedException("QueueSender with index " + i + " not closed.");
        }
    }

    public void verifyNumberTopicPublishers(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        TransmissionManagerWrapper transmissionManagerWrapper = this.getTopicTransmissionManagerWrapper(n);
        if (n2 != transmissionManagerWrapper.getTopicPublisherList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " publishers, actually " + transmissionManagerWrapper.getTopicPublisherList().size() + " publishers present");
        }
    }

    public void verifyNumberTopicPublishers(int n, String string, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        this.checkTopicByName(string);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        if (n2 != topicTransmissionManager.getTopicPublisherList(string).size()) {
            throw new VerifyFailedException("Expected " + n2 + " publishers for topic " + string + ", actually " + topicTransmissionManager.getTopicPublisherList(string).size() + " publishers present");
        }
    }

    public void verifyTopicPublisherClosed(int n, String string, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        this.checkTopicByName(string);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        List list = topicTransmissionManager.getTopicPublisherList(string);
        if (n2 >= list.size()) {
            throw new VerifyFailedException("TopicPublisher with index " + n2 + " is not present.");
        }
        MockTopicPublisher mockTopicPublisher = (MockTopicPublisher)list.get(n2);
        if (!mockTopicPublisher.isClosed()) {
            throw new VerifyFailedException("TopicPublisher of topic " + string + " with index " + n2 + " not closed.");
        }
    }

    public void verifyAllTopicPublishersClosed(int n) {
        this.checkAndGetTopicSessionByIndex(n);
        TransmissionManagerWrapper transmissionManagerWrapper = this.getTopicTransmissionManagerWrapper(n);
        List list = transmissionManagerWrapper.getTopicPublisherList();
        for (int i = 0; i < list.size(); ++i) {
            MockTopicPublisher mockTopicPublisher = (MockTopicPublisher)list.get(i);
            if (mockTopicPublisher.isClosed()) continue;
            throw new VerifyFailedException("TopicPublisher with index " + i + " not closed.");
        }
    }

    public void verifyNumberMessageConsumers(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        TransmissionManagerWrapper transmissionManagerWrapper = this.getTransmissionManagerWrapper(n);
        if (n2 != transmissionManagerWrapper.getMessageConsumerList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " consumers, actually " + transmissionManagerWrapper.getMessageConsumerList().size() + " consumers present");
        }
    }

    public void verifyAllMessageConsumersClosed(int n) {
        this.checkAndGetSessionByIndex(n);
        TransmissionManagerWrapper transmissionManagerWrapper = this.getTransmissionManagerWrapper(n);
        List list = transmissionManagerWrapper.getMessageConsumerList();
        for (int i = 0; i < list.size(); ++i) {
            MockMessageConsumer mockMessageConsumer = (MockMessageConsumer)list.get(i);
            if (mockMessageConsumer.isClosed()) continue;
            throw new VerifyFailedException("MessageConsumer with index " + i + " not closed.");
        }
    }

    public void verifyNumberQueueReceivers(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        QueueTransmissionManager queueTransmissionManager = this.getQueueTransmissionManager(n);
        if (n2 != queueTransmissionManager.getQueueReceiverList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " receivers, actually " + queueTransmissionManager.getQueueReceiverList().size() + " receivers present");
        }
    }

    public void verifyNumberQueueReceivers(int n, String string, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        this.checkQueueByName(string);
        QueueTransmissionManager queueTransmissionManager = this.getQueueTransmissionManager(n);
        if (n2 != queueTransmissionManager.getQueueReceiverList(string).size()) {
            throw new VerifyFailedException("Expected " + n2 + " receivers for queue " + string + ", actually " + queueTransmissionManager.getQueueReceiverList(string).size() + " receivers present");
        }
    }

    public void verifyQueueReceiverClosed(int n, String string, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        this.checkQueueByName(string);
        QueueTransmissionManager queueTransmissionManager = this.getQueueTransmissionManager(n);
        List list = queueTransmissionManager.getQueueReceiverList(string);
        if (n2 >= list.size()) {
            throw new VerifyFailedException("QueueReceiver with index " + n2 + " is not present.");
        }
        MockQueueReceiver mockQueueReceiver = (MockQueueReceiver)list.get(n2);
        if (!mockQueueReceiver.isClosed()) {
            throw new VerifyFailedException("QueueReceiver of queue " + string + " with index " + n2 + " not closed.");
        }
    }

    public void verifyAllQueueReceiversClosed(int n) {
        this.checkAndGetQueueSessionByIndex(n);
        QueueTransmissionManager queueTransmissionManager = this.getQueueTransmissionManager(n);
        List list = queueTransmissionManager.getQueueReceiverList();
        for (int i = 0; i < list.size(); ++i) {
            MockQueueReceiver mockQueueReceiver = (MockQueueReceiver)list.get(i);
            if (mockQueueReceiver.isClosed()) continue;
            throw new VerifyFailedException("QueueReceiver with index " + i + " not closed.");
        }
    }

    public void verifyNumberTopicSubscribers(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        if (n2 != topicTransmissionManager.getTopicSubscriberList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " subscribers, actually " + topicTransmissionManager.getTopicSubscriberList().size() + " subscribers present");
        }
    }

    public void verifyNumberTopicSubscribers(int n, String string, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        this.checkTopicByName(string);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        if (n2 != topicTransmissionManager.getTopicSubscriberList(string).size()) {
            throw new VerifyFailedException("Expected " + n2 + " subscribers for topic " + string + ", actually " + topicTransmissionManager.getTopicSubscriberList(string).size() + " subscribers present");
        }
    }

    public void verifyTopicSubscriberClosed(int n, String string, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        this.checkTopicByName(string);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        List list = topicTransmissionManager.getTopicSubscriberList(string);
        if (n2 >= list.size()) {
            throw new VerifyFailedException("TopicSubscriber with index " + n2 + " is not present.");
        }
        MockTopicSubscriber mockTopicSubscriber = (MockTopicSubscriber)list.get(n2);
        if (!mockTopicSubscriber.isClosed()) {
            throw new VerifyFailedException("TopicSubscriber of topic " + string + " with index " + n2 + " not closed.");
        }
    }

    public void verifyAllTopicSubscribersClosed(int n) {
        this.checkAndGetTopicSessionByIndex(n);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        List list = topicTransmissionManager.getTopicSubscriberList();
        for (int i = 0; i < list.size(); ++i) {
            MockTopicSubscriber mockTopicSubscriber = (MockTopicSubscriber)list.get(i);
            if (mockTopicSubscriber.isClosed()) continue;
            throw new VerifyFailedException("TopicSubscriber with index " + i + " not closed.");
        }
    }

    public void verifyNumberQueueBrowsers(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        QueueTransmissionManager queueTransmissionManager = this.getQueueTransmissionManager(n);
        if (n2 != queueTransmissionManager.getQueueBrowserList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " browsers, actually " + queueTransmissionManager.getQueueBrowserList().size() + " browsers present");
        }
    }

    public void verifyNumberQueueBrowsers(int n, String string, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        this.checkQueueByName(string);
        QueueTransmissionManager queueTransmissionManager = this.getQueueTransmissionManager(n);
        if (n2 != queueTransmissionManager.getQueueBrowserList(string).size()) {
            throw new VerifyFailedException("Expected " + n2 + " browsers for queue " + string + ", actually " + queueTransmissionManager.getQueueBrowserList(string).size() + " browsers present");
        }
    }

    public void verifyQueueBrowserClosed(int n, String string, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        this.checkQueueByName(string);
        QueueTransmissionManager queueTransmissionManager = this.getQueueTransmissionManager(n);
        List list = queueTransmissionManager.getQueueBrowserList(string);
        if (n2 >= list.size()) {
            throw new VerifyFailedException("QueueBrowser with index " + n2 + " is not present.");
        }
        MockQueueBrowser mockQueueBrowser = (MockQueueBrowser)list.get(n2);
        if (!mockQueueBrowser.isClosed()) {
            throw new VerifyFailedException("QueueBrowser of queue " + string + " with index " + n2 + " not closed.");
        }
    }

    public void verifyAllQueueBrowsersClosed(int n) {
        this.checkAndGetQueueSessionByIndex(n);
        QueueTransmissionManager queueTransmissionManager = this.getQueueTransmissionManager(n);
        List list = queueTransmissionManager.getQueueBrowserList();
        for (int i = 0; i < list.size(); ++i) {
            MockQueueBrowser mockQueueBrowser = (MockQueueBrowser)list.get(i);
            if (mockQueueBrowser.isClosed()) continue;
            throw new VerifyFailedException("QueueBrowser with index " + i + " not closed.");
        }
    }

    public void verifyDurableTopicSubscriberPresent(int n, String string) {
        this.checkAndGetTopicSessionByIndex(n);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        if (null == topicTransmissionManager.getDurableTopicSubscriber(string)) {
            throw new VerifyFailedException("Durable subscriber with subscription name " + string + " not present.");
        }
    }

    public void verifyNumberDurableTopicSubscribers(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        if (n2 != topicTransmissionManager.getDurableTopicSubscriberMap().size()) {
            throw new VerifyFailedException("Expected " + n2 + " durable subscribers, actually " + topicTransmissionManager.getDurableTopicSubscriberMap().size() + " durable subscribers present");
        }
    }

    public void verifyNumberDurableTopicSubscribers(int n, String string, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        this.checkTopicByName(string);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        if (n2 != topicTransmissionManager.getDurableTopicSubscriberMap(string).size()) {
            throw new VerifyFailedException("Expected " + n2 + " durable subscribers for topic " + string + ", actually " + topicTransmissionManager.getDurableTopicSubscriberMap(string).size() + " durable subscribers present");
        }
    }

    public void verifyDurableTopicSubscriberClosed(int n, String string) {
        this.checkAndGetTopicSessionByIndex(n);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        MockTopicSubscriber mockTopicSubscriber = topicTransmissionManager.getDurableTopicSubscriber(string);
        if (null == mockTopicSubscriber) {
            throw new VerifyFailedException("Durable TopicSubscriber with subscription name " + string + " not present.");
        }
        if (!mockTopicSubscriber.isClosed()) {
            throw new VerifyFailedException("Durable TopicSubscriber with subscription name " + string + " not closed.");
        }
    }

    public void verifyAllDurableTopicSubscribersClosed(int n) {
        this.checkAndGetTopicSessionByIndex(n);
        TopicTransmissionManager topicTransmissionManager = this.getTopicTransmissionManager(n);
        Iterator iterator = topicTransmissionManager.getDurableTopicSubscriberMap().keySet().iterator();
        while (iterator.hasNext()) {
            MockTopicSubscriber mockTopicSubscriber = (MockTopicSubscriber)topicTransmissionManager.getDurableTopicSubscriberMap().get(iterator.next());
            if (mockTopicSubscriber.isClosed()) continue;
            throw new VerifyFailedException("Durable TopicSubscriber with name " + mockTopicSubscriber.getName() + " not closed.");
        }
    }

    public void verifyNumberQueueSessions(int n) {
        if (n != this.getQueueSessionList().size()) {
            throw new VerifyFailedException("Expected " + n + " queue sessions, actually " + this.getQueueSessionList().size() + " sessions present");
        }
    }

    public void verifyNumberTopicSessions(int n) {
        if (n != this.getTopicSessionList().size()) {
            throw new VerifyFailedException("Expected " + n + " topic sessions, actually " + this.getTopicSessionList().size() + " sessions present");
        }
    }

    public void verifyNumberSessions(int n) {
        if (n != this.getSessionList().size()) {
            throw new VerifyFailedException("Expected " + n + " sessions, actually " + this.getSessionList().size() + " sessions present");
        }
    }

    public void verifyNumberTemporaryQueues(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        if (n2 != this.getTemporaryQueueList(n).size()) {
            throw new VerifyFailedException("Expected " + n2 + " temporary queues, actually " + this.getTemporaryQueueList(n).size() + " temporary queues present");
        }
    }

    public void verifyNumberTemporaryTopics(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        if (n2 != this.getTemporaryTopicList(n).size()) {
            throw new VerifyFailedException("Expected " + n2 + " temporary topics, actually " + this.getTemporaryTopicList(n).size() + " temporary topics present");
        }
    }

    public void verifyTemporaryQueueDeleted(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        MockTemporaryQueue mockTemporaryQueue = this.getTemporaryQueue(n, n2);
        if (null == mockTemporaryQueue) {
            throw new VerifyFailedException("TemporaryQueue with index " + n2 + " is not present.");
        }
        if (!mockTemporaryQueue.isDeleted()) {
            throw new VerifyFailedException("TemporaryQueue with index " + n2 + " not deleted.");
        }
    }

    public void verifyAllTemporaryQueuesDeleted(int n) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getTemporaryQueueList(n);
        for (int i = 0; i < list.size(); ++i) {
            MockTemporaryQueue mockTemporaryQueue = (MockTemporaryQueue)list.get(i);
            if (mockTemporaryQueue.isDeleted()) continue;
            throw new VerifyFailedException("TemporaryQueue with index " + i + " not deleted.");
        }
    }

    public void verifyTemporaryTopicDeleted(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        MockTemporaryTopic mockTemporaryTopic = this.getTemporaryTopic(n, n2);
        if (null == mockTemporaryTopic) {
            throw new VerifyFailedException("TemporaryTopic with index " + n2 + " is not present.");
        }
        if (!mockTemporaryTopic.isDeleted()) {
            throw new VerifyFailedException("TemporaryTopic with index " + n2 + " not deleted.");
        }
    }

    public void verifyAllTemporaryTopicsDeleted(int n) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTemporaryTopicList(n);
        for (int i = 0; i < list.size(); ++i) {
            MockTemporaryTopic mockTemporaryTopic = (MockTemporaryTopic)list.get(i);
            if (mockTemporaryTopic.isDeleted()) continue;
            throw new VerifyFailedException("TemporaryTopic with index " + i + " not deleted.");
        }
    }

    public void verifyMessageEquals(MockMessage mockMessage, MockMessage mockMessage2) {
        if (null == mockMessage) {
            throw new VerifyFailedException("message1 is null");
        }
        if (null == mockMessage2) {
            throw new VerifyFailedException("message2 is null");
        }
        if (!mockMessage.equals(mockMessage2)) {
            throw new VerifyFailedException("messages not equal: message1: " + mockMessage.toString() + ", message2: " + mockMessage2.toString());
        }
    }

    public void verifyCurrentQueueMessageEquals(String string, int n, MockMessage mockMessage) {
        this.checkQueueByName(string);
        List list = this.getCurrentMessageListFromQueue(string);
        if (n >= list.size()) {
            throw new VerifyFailedException("Queue " + string + " contains only " + list.size() + " messages");
        }
        MockMessage mockMessage2 = (MockMessage)list.get(n);
        this.verifyMessageEquals(mockMessage2, mockMessage);
    }

    public void verifyReceivedQueueMessageEquals(String string, int n, MockMessage mockMessage) {
        this.checkQueueByName(string);
        List list = this.getReceivedMessageListFromQueue(string);
        if (n >= list.size()) {
            throw new VerifyFailedException("Queue " + string + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage2 = (MockMessage)list.get(n);
        this.verifyMessageEquals(mockMessage2, mockMessage);
    }

    public void verifyCurrentQueueMessageEquals(int n, int n2, int n3, MockMessage mockMessage) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getCurrentMessageListFromTemporaryQueue(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 >= list.size()) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " contains only " + list.size() + " messages");
        }
        MockMessage mockMessage2 = (MockMessage)list.get(n3);
        this.verifyMessageEquals(mockMessage2, mockMessage);
    }

    public void verifyReceivedQueueMessageEquals(int n, int n2, int n3, MockMessage mockMessage) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getReceivedMessageListFromTemporaryQueue(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 >= list.size()) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage2 = (MockMessage)list.get(n3);
        this.verifyMessageEquals(mockMessage2, mockMessage);
    }

    public void verifyNumberOfCurrentQueueMessages(String string, int n) {
        this.checkQueueByName(string);
        List list = this.getCurrentMessageListFromQueue(string);
        if (n != list.size()) {
            throw new VerifyFailedException("Expected " + n + " messages in queue " + string + ", received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfReceivedQueueMessages(String string, int n) {
        this.checkQueueByName(string);
        List list = this.getReceivedMessageListFromQueue(string);
        if (n != list.size()) {
            throw new VerifyFailedException("Expected " + n + " messages received by queue " + string + ", received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfCurrentQueueMessages(int n, int n2, int n3) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getCurrentMessageListFromTemporaryQueue(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 != list.size()) {
            throw new VerifyFailedException("Expected " + n3 + " messages, received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfReceivedQueueMessages(int n, int n2, int n3) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getReceivedMessageListFromTemporaryQueue(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 != list.size()) {
            throw new VerifyFailedException("Expected " + n3 + " messages, received " + list.size() + " messages");
        }
    }

    public void verifyAllReceivedQueueMessagesAcknowledged(String string) {
        this.checkQueueByName(string);
        List list = this.getReceivedMessageListFromQueue(string);
        for (int i = 0; i < list.size(); ++i) {
            MockMessage mockMessage = (MockMessage)list.get(i);
            if (mockMessage.isAcknowledged()) continue;
            throw new VerifyFailedException("Message " + i + " of queue " + string + " is not acknowledged");
        }
    }

    public void verifyAllReceivedQueueMessagesAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getReceivedMessageListFromTemporaryQueue(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " of session with index " + n + " does not exist");
        }
        for (int i = 0; i < list.size(); ++i) {
            MockMessage mockMessage = (MockMessage)list.get(i);
            if (mockMessage.isAcknowledged()) continue;
            throw new VerifyFailedException("Message " + i + " of temporary queue " + n2 + " is not acknowledged");
        }
    }

    public void verifyReceivedQueueMessageAcknowledged(String string, int n) {
        this.checkQueueByName(string);
        List list = this.getReceivedMessageListFromQueue(string);
        if (n >= list.size()) {
            throw new VerifyFailedException("Queue " + string + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage = (MockMessage)list.get(n);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n + " of queue " + string + " is not acknowledged");
        }
    }

    public void verifyReceivedQueueMessageNotAcknowledged(String string, int n) {
        this.checkQueueByName(string);
        List list = this.getReceivedMessageListFromQueue(string);
        if (n >= list.size()) {
            throw new VerifyFailedException("Queue " + string + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage = (MockMessage)list.get(n);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n + " of queue " + string + " is acknowledged");
        }
    }

    public void verifyReceivedQueueMessageAcknowledged(int n, int n2, int n3) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getReceivedMessageListFromTemporaryQueue(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 >= list.size()) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage = (MockMessage)list.get(n3);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n3 + " of temporary queue " + n2 + " is not acknowledged");
        }
    }

    public void verifyReceivedQueueMessageNotAcknowledged(int n, int n2, int n3) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getReceivedMessageListFromTemporaryQueue(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 >= list.size()) {
            throw new VerifyFailedException("Temporary queue with index " + n2 + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage = (MockMessage)list.get(n3);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n3 + " of temporary queue " + n2 + " is acknowledged");
        }
    }

    public void verifyNumberOfCreatedQueueMessages(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        if (n2 != this.getQueueMessageManager(n).getMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " messages, received " + this.getQueueMessageManager(n).getMessageList().size() + " messages");
        }
    }

    public void verifyNumberOfCreatedQueueBytesMessages(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        if (n2 != this.getQueueMessageManager(n).getBytesMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " bytes messages, received " + this.getQueueMessageManager(n).getBytesMessageList().size() + " bytes messages");
        }
    }

    public void verifyNumberOfCreatedQueueMapMessages(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        if (n2 != this.getQueueMessageManager(n).getMapMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " map messages, received " + this.getQueueMessageManager(n).getMapMessageList().size() + " map messages");
        }
    }

    public void verifyNumberOfCreatedQueueTextMessages(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        if (n2 != this.getQueueMessageManager(n).getTextMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " text messages, received " + this.getQueueMessageManager(n).getTextMessageList().size() + " text messages");
        }
    }

    public void verifyNumberOfCreatedQueueStreamMessages(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        if (n2 != this.getQueueMessageManager(n).getStreamMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " stream messages, received " + this.getQueueMessageManager(n).getStreamMessageList().size() + " stream messages");
        }
    }

    public void verifyNumberOfCreatedQueueObjectMessages(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        if (n2 != this.getQueueMessageManager(n).getObjectMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " object messages, received " + this.getQueueMessageManager(n).getObjectMessageList().size() + " object messages");
        }
    }

    public void verifyCreatedQueueMessageAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedQueueBytesMessageAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getBytesMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " bytes messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueBytesMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getBytesMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " bytes messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedQueueMapMessageAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getMapMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " map messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueMapMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getMapMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " map messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedQueueTextMessageAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getTextMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " text messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueTextMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getTextMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " text messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedQueueStreamMessageAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getStreamMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " stream messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueStreamMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getStreamMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " stream messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedQueueObjectMessageAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getObjectMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " object messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueObjectMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetQueueSessionByIndex(n);
        List list = this.getQueueMessageManager(n).getObjectMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " object messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCurrentTopicMessageEquals(String string, int n, MockMessage mockMessage) {
        this.checkTopicByName(string);
        List list = this.getCurrentMessageListFromTopic(string);
        if (n >= list.size()) {
            throw new VerifyFailedException("Topic " + string + " contains only " + list.size() + " messages");
        }
        MockMessage mockMessage2 = (MockMessage)list.get(n);
        this.verifyMessageEquals(mockMessage2, mockMessage);
    }

    public void verifyReceivedTopicMessageEquals(String string, int n, MockMessage mockMessage) {
        this.checkTopicByName(string);
        List list = this.getReceivedMessageListFromTopic(string);
        if (n >= list.size()) {
            throw new VerifyFailedException("Topic " + string + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage2 = (MockMessage)list.get(n);
        this.verifyMessageEquals(mockMessage2, mockMessage);
    }

    public void verifyCurrentTopicMessageEquals(int n, int n2, int n3, MockMessage mockMessage) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getCurrentMessageListFromTemporaryTopic(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 >= list.size()) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " contains only " + list.size() + " messages");
        }
        MockMessage mockMessage2 = (MockMessage)list.get(n3);
        this.verifyMessageEquals(mockMessage2, mockMessage);
    }

    public void verifyReceivedTopicMessageEquals(int n, int n2, int n3, MockMessage mockMessage) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getReceivedMessageListFromTemporaryTopic(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 >= list.size()) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage2 = (MockMessage)list.get(n3);
        this.verifyMessageEquals(mockMessage2, mockMessage);
    }

    public void verifyNumberOfCurrentTopicMessages(String string, int n) {
        this.checkTopicByName(string);
        List list = this.getCurrentMessageListFromTopic(string);
        if (n != list.size()) {
            throw new VerifyFailedException("Expected " + n + " messages in topic " + string + ", received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfReceivedTopicMessages(String string, int n) {
        this.checkTopicByName(string);
        List list = this.getReceivedMessageListFromTopic(string);
        if (n != list.size()) {
            throw new VerifyFailedException("Expected " + n + " messages received by topic " + string + ", received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfCurrentTopicMessages(int n, int n2, int n3) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getCurrentMessageListFromTemporaryTopic(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 != list.size()) {
            throw new VerifyFailedException("Expected " + n3 + " messages, received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfReceivedTopicMessages(int n, int n2, int n3) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getReceivedMessageListFromTemporaryTopic(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 != list.size()) {
            throw new VerifyFailedException("Expected " + n3 + " messages, received " + list.size() + " messages");
        }
    }

    public void verifyAllReceivedTopicMessagesAcknowledged(String string) {
        this.checkTopicByName(string);
        List list = this.getReceivedMessageListFromTopic(string);
        for (int i = 0; i < list.size(); ++i) {
            MockMessage mockMessage = (MockMessage)list.get(i);
            if (mockMessage.isAcknowledged()) continue;
            throw new VerifyFailedException("Message " + i + " of topic " + string + " is not acknowledged");
        }
    }

    public void verifyAllReceivedTopicMessagesAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getReceivedMessageListFromTemporaryTopic(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " of session with index " + n + " does not exist");
        }
        for (int i = 0; i < list.size(); ++i) {
            MockMessage mockMessage = (MockMessage)list.get(i);
            if (mockMessage.isAcknowledged()) continue;
            throw new VerifyFailedException("Message " + i + " of temporary topic " + n2 + " is not acknowledged");
        }
    }

    public void verifyReceivedTopicMessageAcknowledged(String string, int n) {
        this.checkTopicByName(string);
        List list = this.getReceivedMessageListFromTopic(string);
        if (n >= list.size()) {
            throw new VerifyFailedException("Topic " + string + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage = (MockMessage)list.get(n);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n + " of topic " + string + " is not acknowledged");
        }
    }

    public void verifyReceivedTopicMessageNotAcknowledged(String string, int n) {
        this.checkTopicByName(string);
        List list = this.getReceivedMessageListFromTopic(string);
        if (n >= list.size()) {
            throw new VerifyFailedException("Topic " + string + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage = (MockMessage)list.get(n);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n + " of topic " + string + " is acknowledged");
        }
    }

    public void verifyReceivedTopicMessageAcknowledged(int n, int n2, int n3) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getReceivedMessageListFromTemporaryTopic(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 >= list.size()) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage = (MockMessage)list.get(n3);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n3 + " of temporary topic " + n2 + " is not acknowledged");
        }
    }

    public void verifyReceivedTopicMessageNotAcknowledged(int n, int n2, int n3) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getReceivedMessageListFromTemporaryTopic(n, n2);
        if (null == list) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " of session with index " + n + " does not exist");
        }
        if (n3 >= list.size()) {
            throw new VerifyFailedException("Temporary topic with index " + n2 + " received only " + list.size() + " messages");
        }
        MockMessage mockMessage = (MockMessage)list.get(n3);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n3 + " of temporary topic " + n2 + " is acknowledged");
        }
    }

    public void verifyNumberOfCreatedTopicMessages(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        if (n2 != this.getTopicMessageManager(n).getMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " messages, received " + this.getTopicMessageManager(n).getMessageList().size() + " messages");
        }
    }

    public void verifyNumberOfCreatedTopicBytesMessages(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        if (n2 != this.getTopicMessageManager(n).getBytesMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " bytes messages, received " + this.getTopicMessageManager(n).getBytesMessageList().size() + " bytes messages");
        }
    }

    public void verifyNumberOfCreatedTopicMapMessages(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        if (n2 != this.getTopicMessageManager(n).getMapMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " map messages, received " + this.getTopicMessageManager(n).getMapMessageList().size() + " map messages");
        }
    }

    public void verifyNumberOfCreatedTopicTextMessages(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        if (n2 != this.getTopicMessageManager(n).getTextMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " text messages, received " + this.getTopicMessageManager(n).getTextMessageList().size() + " text messages");
        }
    }

    public void verifyNumberOfCreatedTopicStreamMessages(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        if (n2 != this.getTopicMessageManager(n).getStreamMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " stream messages, received " + this.getTopicMessageManager(n).getStreamMessageList().size() + " stream messages");
        }
    }

    public void verifyNumberOfCreatedTopicObjectMessages(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        if (n2 != this.getTopicMessageManager(n).getObjectMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " object messages, received " + this.getTopicMessageManager(n).getObjectMessageList().size() + " object messages");
        }
    }

    public void verifyCreatedTopicMessageAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedTopicBytesMessageAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getBytesMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " bytes messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicBytesMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getBytesMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " bytes messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedTopicMapMessageAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getMapMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " map messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicMapMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getMapMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " map messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedTopicTextMessageAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getTextMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " text messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicTextMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getTextMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " text messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedTopicStreamMessageAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getStreamMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " stream messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicStreamMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getStreamMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " stream messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedTopicObjectMessageAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getObjectMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " object messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicObjectMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetTopicSessionByIndex(n);
        List list = this.getTopicMessageManager(n).getObjectMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " object messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyNumberOfCreatedMessages(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        if (n2 != this.getMessageManager(n).getMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " messages, received " + this.getMessageManager(n).getMessageList().size() + " messages");
        }
    }

    public void verifyNumberOfCreatedBytesMessages(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        if (n2 != this.getMessageManager(n).getBytesMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " bytes messages, received " + this.getMessageManager(n).getBytesMessageList().size() + " bytes messages");
        }
    }

    public void verifyNumberOfCreatedMapMessages(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        if (n2 != this.getMessageManager(n).getMapMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " map messages, received " + this.getMessageManager(n).getMapMessageList().size() + " map messages");
        }
    }

    public void verifyNumberOfCreatedTextMessages(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        if (n2 != this.getMessageManager(n).getTextMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " text messages, received " + this.getMessageManager(n).getTextMessageList().size() + " text messages");
        }
    }

    public void verifyNumberOfCreatedStreamMessages(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        if (n2 != this.getMessageManager(n).getStreamMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " stream messages, received " + this.getMessageManager(n).getStreamMessageList().size() + " stream messages");
        }
    }

    public void verifyNumberOfCreatedObjectMessages(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        if (n2 != this.getMessageManager(n).getObjectMessageList().size()) {
            throw new VerifyFailedException("Expected " + n2 + " object messages, received " + this.getMessageManager(n).getObjectMessageList().size() + " object messages");
        }
    }

    public void verifyCreatedMessageAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedBytesMessageAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getBytesMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " bytes messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedBytesMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getBytesMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " bytes messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedMapMessageAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getMapMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " map messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedMapMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getMapMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " map messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedTextMessageAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getTextMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " text messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedTextMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getTextMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " text messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedStreamMessageAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getStreamMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " stream messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedStreamMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getStreamMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " stream messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    public void verifyCreatedObjectMessageAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getObjectMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " object messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (!mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is not acknowledged");
        }
    }

    public void verifyCreatedObjectMessageNotAcknowledged(int n, int n2) {
        this.checkAndGetSessionByIndex(n);
        List list = this.getMessageManager(n).getObjectMessageList();
        if (n2 >= list.size()) {
            throw new VerifyFailedException("Only " + list.size() + " object messages created for session " + n);
        }
        MockMessage mockMessage = (MockMessage)list.get(n2);
        if (mockMessage.isAcknowledged()) {
            throw new VerifyFailedException("Message " + n2 + " of session " + n + " is acknowledged");
        }
    }

    private MockQueueSession checkAndGetQueueSessionByIndex(int n) {
        if (null == this.getCurrentQueueConnection()) {
            throw new VerifyFailedException("No QueueConnection present.");
        }
        MockQueueSession mockQueueSession = this.getQueueSession(n);
        if (null == mockQueueSession) {
            throw new VerifyFailedException("QueueSession with index " + n + " does not exist.");
        }
        return mockQueueSession;
    }

    private MockTopicSession checkAndGetTopicSessionByIndex(int n) {
        if (null == this.getCurrentTopicConnection()) {
            throw new VerifyFailedException("No TopicConnection present.");
        }
        MockTopicSession mockTopicSession = this.getTopicSession(n);
        if (null == mockTopicSession) {
            throw new VerifyFailedException("TopicSession with index " + n + " does not exist.");
        }
        return mockTopicSession;
    }

    private MockSession checkAndGetSessionByIndex(int n) {
        if (null == this.getCurrentConnection()) {
            throw new VerifyFailedException("No Connection present.");
        }
        MockSession mockSession = this.getSession(n);
        if (null == mockSession) {
            throw new VerifyFailedException("Session with index " + n + " does not exist.");
        }
        return mockSession;
    }

    private void checkQueueByName(String string) {
        DestinationManager destinationManager = this.getDestinationManager();
        if (null == destinationManager.getQueue(string)) {
            throw new VerifyFailedException("Queue with name " + string + " is not present.");
        }
    }

    private void checkTopicByName(String string) {
        DestinationManager destinationManager = this.getDestinationManager();
        if (null == destinationManager.getTopic(string)) {
            throw new VerifyFailedException("Topic with name " + string + " is not present.");
        }
    }
}

