/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AccessorKey
implements Externalizable {
    private static final long serialVersionUID = 400L;
    private String className;
    private String fieldName;
    private int hashCode;
    private AccessorType type;

    public AccessorKey() {
    }

    public AccessorKey(String className, String fieldName, AccessorType type) {
        this.className = className;
        this.fieldName = fieldName;
        int PRIME = 31;
        int result = 1;
        result = 31 * result + className.hashCode();
        result = 31 * result + (fieldName == null ? 0 : fieldName.hashCode());
        this.hashCode = result = 31 * result + type.hashCode();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.className);
        out.writeObject(this.fieldName);
        out.writeInt(this.hashCode);
        out.writeObject((Object)this.type);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = in.readUTF();
        this.fieldName = (String)in.readObject();
        this.hashCode = in.readInt();
        this.type = (AccessorType)((Object)in.readObject());
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public AccessorType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessorKey other = (AccessorKey)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public String toString() {
        return this.className + "-" + this.fieldName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessorType {
        FieldAccessor,
        ClassObjectType;

    }
}

