/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.async;

import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;

public class AsyncEndCombinationTest
extends JbpmTestCase {
    public void testConcurrentEndScenario1() {
        this.deployJpdlXmlString("<process name='AsyncEndCombination'>  <start>    <transition to='f' />  </start>  <fork name='f'>    <transition to='a' continue='async' />    <transition to='end' />  </fork>  <state name='a' />  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AsyncEndCombination");
        AsyncEndCombinationTest.assertEquals((String)"ended", (String)processInstance.getState());
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).list();
        AsyncEndCombinationTest.assertEquals((int)0, (int)jobs.size());
    }

    public void testConcurrentScenario2() {
        this.deployJpdlXmlString("<process name='AsyncEndCombination'>  <start>    <transition to='f' />  </start>  <fork name='f'>    <transition to='end' />    <transition to='a' continue='async' />  </fork>  <state name='a' />  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AsyncEndCombination");
        AsyncEndCombinationTest.assertEquals((String)"ended", (String)processInstance.getState());
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).list();
        AsyncEndCombinationTest.assertEquals((int)0, (int)jobs.size());
    }

    public void testAsyncToEnd() {
        this.deployJpdlXmlString("<process name='AsyncEndCombination'>  <start>    <transition to='s' />  </start>  <state name='s'>    <transition to='end' continue='async' />  </state>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AsyncEndCombination");
        String processInstanceId = processInstance.getId();
        processInstance = this.executionService.signalExecutionById(processInstanceId);
        AsyncEndCombinationTest.assertEquals((String)"async", (String)processInstance.getState());
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        AsyncEndCombinationTest.assertEquals((int)1, (int)jobs.size());
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        jobs = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        AsyncEndCombinationTest.assertEquals((int)0, (int)jobs.size());
        AsyncEndCombinationTest.assertNull((Object)this.executionService.findProcessInstanceById(processInstanceId));
    }
}

