/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.foreach;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.api.history.HistoryTask;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class ForEachTest
extends JbpmTestCase {
    public void testForEachLiteral() {
        this.deployJpdlXmlString("<process name='ForEachLiteral' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' var='assign' in='alex, mike'>      <transition name='left' to='task1' g='-44,-18'/>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='Big car' g='-43,-18'/>   </task>   <state name='Big car' >      <transition name='to join2' to='join2' g='-43,-18'/>   </state>    <join name='join2' g='192,511,57,44' multiplicity='2'>      <transition name='to end1' to='end1' g='-42,-18'/>   </join>   <end g='193,606,38,33' name='end1'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForEachLiteral");
        Task taskAlex = this.taskService.createTaskQuery().assignee("alex").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskAlex.getActivityName());
        this.taskService.completeTask(taskAlex.getId());
        Task taskMike = this.taskService.createTaskQuery().assignee("mike").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskMike.getActivityName());
        this.taskService.completeTask(taskMike.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        ForEachTest.assertEquals((int)2, (int)processInstance.getExecutions().size());
        for (Execution exec : processInstance.getExecutions()) {
            ForEachTest.assertEquals((String)"active-concurrent", (String)exec.getState());
            this.executionService.signalExecutionById(exec.getId());
        }
        HistoryProcessInstance history = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ForEachTest.assertEquals((String)"ended", (String)history.getState());
        ForEachTest.assertEquals((String)"end1", (String)history.getEndActivityName());
    }

    public void testForEachList() {
        this.deployJpdlXmlString("<process name='ForEachList' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' var='assign' in='#{actors}'>      <transition name='left' to='task1' g='-44,-18'/>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='Big car' g='-43,-18'/>   </task>   <state name='Big car' >      <transition name='to join2' to='join2' g='-43,-18'/>   </state>    <join name='join2' g='192,511,57,44' multiplicity='#{actors.size()}'>      <transition name='to end1' to='end1' g='-42,-18'/>   </join>   <end g='193,606,38,33' name='end1'/></process>");
        Map<String, List<String>> variables = Collections.singletonMap("actors", Arrays.asList("alex", "mike"));
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForEachList", variables);
        Task taskAlex = this.taskService.createTaskQuery().assignee("alex").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskAlex.getActivityName());
        this.taskService.completeTask(taskAlex.getId());
        Task taskMike = this.taskService.createTaskQuery().assignee("mike").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskMike.getActivityName());
        this.taskService.completeTask(taskMike.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        ForEachTest.assertEquals((int)2, (int)processInstance.getExecutions().size());
        for (Execution exec : processInstance.getExecutions()) {
            ForEachTest.assertEquals((String)"active-concurrent", (String)exec.getState());
            this.executionService.signalExecutionById(exec.getId());
        }
        HistoryProcessInstance history = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ForEachTest.assertEquals((String)"ended", (String)history.getState());
        ForEachTest.assertEquals((String)"end1", (String)history.getEndActivityName());
    }

    public void testForEachArray() {
        this.deployJpdlXmlString("<process name='ForEachArray' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' var='assign' in='#{actors}'>      <transition name='left' to='task1' g='-44,-18'/>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='Big car' g='-43,-18'/>   </task>   <state name='Big car' >    <transition name='to join2' to='join2' g='-43,-18'/>   </state>    <join name='join2' g='192,511,57,44' multiplicity='#{length(actors)}'>      <transition name='to end1' to='end1' g='-42,-18'/>   </join>   <end g='193,606,38,33' name='end1'/></process>");
        Map<String, String[]> variables = Collections.singletonMap("actors", new String[]{"alex", "mike"});
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForEachArray", variables);
        Task taskAlex = this.taskService.createTaskQuery().assignee("alex").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskAlex.getActivityName());
        this.taskService.completeTask(taskAlex.getId());
        Task taskMike = this.taskService.createTaskQuery().assignee("mike").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskMike.getActivityName());
        this.taskService.completeTask(taskMike.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        ForEachTest.assertEquals((int)2, (int)processInstance.getExecutions().size());
        for (Execution exec : processInstance.getExecutions()) {
            ForEachTest.assertEquals((String)"active-concurrent", (String)exec.getState());
            this.executionService.signalExecutionById(exec.getId());
        }
        HistoryProcessInstance history = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ForEachTest.assertEquals((String)"ended", (String)history.getState());
        ForEachTest.assertEquals((String)"end1", (String)history.getEndActivityName());
    }

    public void testForEachInvalid() {
        this.deployJpdlXmlString("<process name='ForEachInvalid' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' var='assign' in='#{actors}'>      <transition name='left' to='task1' g='-44,-18'/>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='Big car' g='-43,-18'/>   </task>   <state name='Big car' >    <transition name='to join2' to='join2' g='-43,-18'/>   </state>    <join name='join2' g='192,511,57,44'>      <transition name='to end1' to='end1' g='-42,-18'/>   </join>   <end g='193,606,38,33' name='end1'/></process>");
        Map<String, Date> variables = Collections.singletonMap("actors", new Date());
        try {
            this.executionService.startProcessInstanceByKey("ForEachInvalid", variables);
            ForEachTest.fail((String)"It should fail, since for-each list of items is a Date object");
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
    }

    public void testForEachMissingVar() {
        try {
            this.deployJpdlXmlString("<process name='ForEachMissingVar' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' in='#{actors}' >      <transition name='left' to='task1' g='-44,-18'/>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='Big car' g='-43,-18'/>   </task>   <state name='Big car' >    <transition name='to join2' to='join2' g='-43,-18'/>   </state>    <join name='join2' g='192,511,57,44'>      <transition name='to end1' to='end1' g='-42,-18'/>   </join>   <end g='193,606,38,33' name='end1'/></process>");
            ForEachTest.fail((String)"expected foreach with missing variable to fail");
        }
        catch (JbpmException e) {
            e.printStackTrace();
        }
    }

    public void testForEachJoinMultiplicity() {
        this.deployJpdlXmlString("<process name='ForEachJoinMultiplicity' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' var='assign' in='#{actors}'>      <transition name='left' to='task1' g='-44,-18'/>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='join2' g='-43,-18'/>   </task>   <join name='join2' g='192,511,57,44' multiplicity='#{actors.size()-1}'>      <transition name='to end1' to='end1' g='-42,-18'/>   </join>   <end g='193,606,38,33' name='end1'/></process>");
        Map<String, List<String>> variables = Collections.singletonMap("actors", Arrays.asList("alex", "mike"));
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForEachJoinMultiplicity", variables);
        Task taskAlex = this.taskService.createTaskQuery().assignee("alex").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskAlex.getActivityName());
        this.taskService.completeTask(taskAlex.getId());
        Task taskMike = this.taskService.createTaskQuery().assignee("mike").uniqueResult();
        ForEachTest.assertNull((Object)taskMike);
        HistoryProcessInstance history = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ForEachTest.assertEquals((String)"ended", (String)history.getState());
        ForEachTest.assertEquals((String)"end1", (String)history.getEndActivityName());
    }

    public void testForEachConditionMet() {
        this.deployJpdlXmlString("<process name='ForEachConditionMet' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' var='assign' in='alex, mike, peter'>      <transition name='left' to='task1' g='-44,-18'>         <condition expr='#{assign != &quot;peter&quot;}' />       </transition>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='Big car' g='-43,-18'/>   </task>   <state name='Big car' >      <transition name='to join2' to='join2' g='-43,-18'/>   </state>    <join name='join2' g='192,511,57,44' multiplicity='2'>      <transition name='to end1' to='end1' g='-42,-18'/>   </join>   <end g='193,606,38,33' name='end1'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForEachConditionMet");
        Task taskAlex = this.taskService.createTaskQuery().assignee("alex").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskAlex.getActivityName());
        this.taskService.completeTask(taskAlex.getId());
        Task taskMike = this.taskService.createTaskQuery().assignee("mike").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskMike.getActivityName());
        this.taskService.completeTask(taskMike.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        ForEachTest.assertEquals((int)2, (int)processInstance.getExecutions().size());
        for (Execution exec : processInstance.getExecutions()) {
            ForEachTest.assertEquals((String)"active-concurrent", (String)exec.getState());
            this.executionService.signalExecutionById(exec.getId());
        }
        HistoryProcessInstance history = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ForEachTest.assertEquals((String)"ended", (String)history.getState());
        ForEachTest.assertEquals((String)"end1", (String)history.getEndActivityName());
    }

    public void testForEachConditionNotMet() {
        this.deployJpdlXmlString("<process name='ForEachConditionNotMet' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' var='assign' in='alex, mike'>      <transition name='left' to='task1' g='-44,-18'>         <condition expr='#{assign==&quot;peter&quot;}' />       </transition>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='Big car' g='-43,-18'/>   </task>   <state name='Big car' >       <transition name='to join2' to='join2' g='-43,-18'/>   </state>    <join name='join2' g='192,511,57,44'>      <transition name='to end1' to='end1' g='-42,-18'/>   </join>   <end g='193,606,38,33' name='end1'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForEachConditionNotMet");
        List tasks = this.taskService.createTaskQuery().list();
        ForEachTest.assertEquals((int)0, (int)tasks.size());
        HistoryProcessInstance history = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ForEachTest.assertEquals((String)"ended", (String)history.getState());
    }

    public void testForEachNoTransitions() {
        try {
            this.deployJpdlXmlString("<process name='ForEachNoTransition' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' var='assign' in='#{actors}'>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='Big car' g='-43,-18'/>   </task>   <state name='Big car' >    <transition name='to join2' to='join2' g='-43,-18'/>   </state>    <join name='join2' g='192,511,57,44'>      <transition name='to end1' to='end1' g='-42,-18'/>   </join>   <end g='193,606,38,33' name='end1'/></process>");
            ForEachTest.fail((String)"expected deployment failure");
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
    }

    public void testForEachJoinMultiplicityLeftTask() {
        this.deployJpdlXmlString("<process name='ForEachJoinMultiplicity' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' var='assign' in='#{actors}'>      <transition name='left' to='task1' g='-44,-18'/>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='join2' g='-43,-18'/>   </task>   <join name='join2' g='192,511,57,44' multiplicity='#{actors.size()-1}'>      <transition name='to Big car' to='Big car' g='-42,-18'/>   </join>   <state name='Big car' >    <transition name='to end1' to='end1' g='-43,-18'/>   </state>    <end g='193,606,38,33' name='end1'/></process>");
        Map<String, List<String>> variables = Collections.singletonMap("actors", Arrays.asList("alex", "mike"));
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForEachJoinMultiplicity", variables);
        Task taskAlex = this.taskService.createTaskQuery().assignee("alex").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskAlex.getActivityName());
        this.taskService.completeTask(taskAlex.getId());
        Task taskMike = this.taskService.createTaskQuery().assignee("mike").uniqueResult();
        ForEachTest.assertNull((Object)taskMike);
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        this.executionService.signalExecutionById(processInstance.getId());
        HistoryProcessInstance history = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ForEachTest.assertEquals((String)"ended", (String)history.getState());
        ForEachTest.assertEquals((String)"end1", (String)history.getEndActivityName());
        List historyTasks = this.historyService.createHistoryTaskQuery().assignee("alex").list();
        ForEachTest.assertEquals((int)1, (int)historyTasks.size());
        ForEachTest.assertEquals((String)"completed", (String)((HistoryTask)historyTasks.get(0)).getState());
        historyTasks = this.historyService.createHistoryTaskQuery().assignee("mike").list();
        ForEachTest.assertEquals((int)1, (int)historyTasks.size());
        ForEachTest.assertEquals((String)"obsolete", (String)((HistoryTask)historyTasks.get(0)).getState());
    }

    public void testForEachJoinMultiplicityLeftTasks() {
        this.deployJpdlXmlString("<process name='ForEachJoinMultiplicity' xmlns='http://jbpm.org/4.4/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to foreach1' to='foreach1'/>   </start>   <foreach g='185,95,49,50' name='foreach1' var='assign' in='#{actors}'>      <transition name='left' to='task1' g='-44,-18'/>   </foreach>   <task name='task1' g='90,177,73,44' assignee='#{assign}'>      <transition name='to state' to='join2' g='-43,-18'/>   </task>   <join name='join2' g='192,511,57,44' multiplicity='#{actors.size()-2}'>      <transition name='to Big car' to='Big car' g='-42,-18'/>   </join>   <state name='Big car' >    <transition name='to end1' to='end1' g='-43,-18'/>   </state>    <end g='193,606,38,33' name='end1'/></process>");
        Map<String, List<String>> variables = Collections.singletonMap("actors", Arrays.asList("alex", "mike", "bob"));
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForEachJoinMultiplicity", variables);
        Task taskAlex = this.taskService.createTaskQuery().assignee("alex").uniqueResult();
        ForEachTest.assertEquals((String)"task1", (String)taskAlex.getActivityName());
        this.taskService.completeTask(taskAlex.getId());
        Task taskMike = this.taskService.createTaskQuery().assignee("mike").uniqueResult();
        ForEachTest.assertNull((Object)taskMike);
        Task taskBob = this.taskService.createTaskQuery().assignee("bob").uniqueResult();
        ForEachTest.assertNull((Object)taskBob);
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        this.executionService.signalExecutionById(processInstance.getId());
        HistoryProcessInstance history = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ForEachTest.assertEquals((String)"ended", (String)history.getState());
        ForEachTest.assertEquals((String)"end1", (String)history.getEndActivityName());
        List historyTasks = this.historyService.createHistoryTaskQuery().assignee("alex").list();
        ForEachTest.assertEquals((int)1, (int)historyTasks.size());
        ForEachTest.assertEquals((String)"completed", (String)((HistoryTask)historyTasks.get(0)).getState());
        historyTasks = this.historyService.createHistoryTaskQuery().assignee("mike").list();
        ForEachTest.assertEquals((int)1, (int)historyTasks.size());
        ForEachTest.assertEquals((String)"obsolete", (String)((HistoryTask)historyTasks.get(0)).getState());
        historyTasks = this.historyService.createHistoryTaskQuery().assignee("bob").list();
        ForEachTest.assertEquals((int)1, (int)historyTasks.size());
        ForEachTest.assertEquals((String)"obsolete", (String)((HistoryTask)historyTasks.get(0)).getState());
    }
}

