/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class NonNestedForkJoin
extends JbpmTestCase {
    public void testNotFullyNestedWithSwimlanes() {
        this.deployJpdlXmlString("<?xml version='1.0' encoding='UTF-8'?><process name='JBPM-2570'> \t<swimlane candidate-groups='A' name='A'/>\t<swimlane candidate-groups='B' name='B'/>\t<swimlane candidate-groups='C' name='C'/>\t<start name='start1'>\t\t<transition to='fork1'/>\t</start>\t<fork name='fork1'>\t\t<transition to='task1a'/>\t\t<transition to='task1b'/>\t\t<transition to='task1c'/>\t</fork>\t<task name='task1a' swimlane='A'>\t\t<transition to='join1'/>\t</task>\t<task name='task1b' swimlane='B'>\t\t<transition to='join1'/>\t</task>\t<task name='task1c' swimlane='C'>\t\t<transition to='join2'/>\t</task>\t<join name='join1'>\t\t<transition to='task2a'/>\t</join>\t<task name='task2a' swimlane='B'>\t\t<transition to='join2'/>\t</task>\t<join name='join2'>\t\t<transition to='task3a'/>\t</join>\t<task name='task3a'>\t\t<transition to='end1'/>\t</task>\t<end name='end1'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("JBPM-2570");
        String processInstanceId = processInstance.getId();
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        taskQuery.processInstanceId(processInstanceId);
        NonNestedForkJoin.assertEquals((int)3, (int)taskQuery.list().size());
        this.assertActivityActive(processInstanceId, "task1a");
        Task t1a = NonNestedForkJoin.getTask((List)taskQuery.list(), (String)"task1a");
        this.taskService.assignTask(t1a.getId(), "For SLA");
        this.taskService.completeTask(t1a.getId());
        this.assertActivityActive(processInstanceId, "task1b");
        Task t1b = NonNestedForkJoin.getTask((List)taskQuery.list(), (String)"task1b");
        this.taskService.assignTask(t1b.getId(), "For SLB");
        this.taskService.completeTask(t1b.getId());
        this.assertActivitiesActive(processInstanceId, new String[]{"task1c", "task2a"});
        this.assertNotActivityActive(processInstanceId, "task3a");
        this.assertActivityActive(processInstanceId, "task2a");
        this.taskService.completeTask(NonNestedForkJoin.getTask((List)taskQuery.list(), (String)"task2a").getId());
        Task t1c = NonNestedForkJoin.getTask((List)taskQuery.list(), (String)"task1c");
        this.taskService.assignTask(t1c.getId(), "For SLC");
        this.taskService.completeTask(t1c.getId());
        this.assertActivitiesActive(processInstanceId, new String[]{"task3a"});
        Task t3a = NonNestedForkJoin.getTask((List)taskQuery.list(), (String)"task3a");
        this.taskService.completeTask(t3a.getId());
        this.assertProcessInstanceEnded(processInstance);
    }
}

