/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.HashMap;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class ForkJoinInSameTransactionTest
extends JbpmTestCase {
    public void testForkToJoinInOneTransaction() {
        this.deployJpdlXmlString("<process name='ForkJoinInOneTransaction'>  <start>    <transition to='theFork' />  </start>  <fork name='theFork'>    <transition to='theJoin' />    <transition to='theJoin' />  </fork>  <join name='theJoin'>    <transition to='end' />  </join>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForkJoinInOneTransaction");
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testForkToJoinAfterStateInOneTransaction() {
        this.deployJpdlXmlString("<process name='ForkJoinInOneTransaction'>  <start>    <transition to='wait' />  </start>  <state name='wait'>    <transition name='go on' to='theFork' />  </state>  <fork name='theFork'>    <transition to='theJoin' />    <transition to='theJoin' />  </fork>  <join name='theJoin'>    <transition to='end' />  </join>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForkJoinInOneTransaction");
        this.executionService.signalExecutionById(processInstance.getId(), "go on");
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testForkToJoinWithActivitiesInOneTransaction() {
        this.deployJpdlXmlString("<process name='ForkJoinInOneTransaction'>  <start>    <transition to='theFork' />  </start>  <fork name='theFork'>    <transition to='left' />    <transition to='right' />  </fork>  <custom name='left' class='org.jbpm.test.activities.PassThroughActivity' >    <transition to='theJoin' />  </custom>  <custom name='right' class='org.jbpm.test.activities.PassThroughActivity' >    <transition to='theJoin' />  </custom>  <join name='theJoin'>    <transition to='end' />  </join>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForkJoinInOneTransaction");
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testForkToJoinInLoopInOneTransaction() {
        this.deployJpdlXmlString("<process name='ForkJoinInOneTransaction'>  <start>    <transition to='checkLoop' />  </start>  <decision name='checkLoop'>    <transition to='end'>      <condition expr='#{testVar &gt; 10}' />    </transition>    <transition to='theFork' />  </decision>  <fork name='theFork'>    <transition to='left' />    <transition to='right' />  </fork>  <custom name='left' class='org.jbpm.test.activities.PassThroughActivity' >    <transition to='theJoin' />  </custom>  <custom name='right' class='org.jbpm.test.activities.PassThroughActivity' >    <transition to='theJoin' />  </custom>  <join name='theJoin'>    <transition to='incrementLoopVar' />  </join>  <custom name='incrementLoopVar' class='org.jbpm.test.activities.IncrementVariableActivity' >    <transition to='checkLoop' />  </custom>  <end name='end' /></process>");
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("testVar", new Integer(0));
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForkJoinInOneTransaction", vars);
        this.assertProcessInstanceEnded(processInstance);
    }
}

