/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.async.eventlistener;

import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;

public class AsyncEventListenerTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/async/eventlistener/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testAsyncEventListener() throws Exception {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AsyncEventListener");
        String processInstanceId = processInstance.getId();
        Job job = this.managementService.createJobQuery().processInstanceId(processInstanceId).uniqueResult();
        try {
            this.managementService.executeJob(job.getId());
            AsyncEventListenerTest.fail((String)"expected exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        job = this.managementService.createJobQuery().processInstanceId(processInstanceId).uniqueResult();
        AsyncEventListenerTest.assertNotNull((Object)job);
        this.assertTextPresent("could not send email", job.getException());
        AsyncEventListenerTest.assertEquals((int)2, (int)job.getRetries());
    }
}

