/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.test.subprocess;

import java.util.Collection;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.CollectionAssertions;

public class SubProcessTest
extends JbpmTestCase {
    private static final String SIMPLE_SUBPROCESS = "<definitions>  <process id='simpleSubProcess'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='mySubProcess' />    <subProcess id='mySubProcess'>      <startEvent id='subProcessStart' />      <sequenceFlow id='subFlow1' sourceRef='subProcessStart' targetRef='subTask' />      <userTask id='subTask' name='importantTask' />      <sequenceFlow id='subFlow2' sourceRef='subTask' targetRef='subEnd' />      <endEvent id='subEnd' />    </subProcess>    <sequenceFlow id='flow2' sourceRef='mySubProcess' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String SIMPLE_PARALLEL_SUBPROCESS = "<definitions>  <process id='simpleParallelSubProcess'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='mySubProcess' />    <subProcess id='mySubProcess'>      <startEvent id='subProcessStart1' />      <sequenceFlow id='subFlow1' sourceRef='subProcessStart1' targetRef='subTask1' />      <userTask id='subTask1' name='importantTask1' />      <sequenceFlow id='subFlow2' sourceRef='subTask1' targetRef='subEnd1' />      <endEvent id='subEnd1' />      <startEvent id='subProcessStart2' />      <sequenceFlow id='subFlow3' sourceRef='subProcessStart2' targetRef='subTask2' />      <userTask id='subTask2' name='importantTask2' />      <sequenceFlow id='subFlow4' sourceRef='subTask2' targetRef='subEnd2' />      <endEvent id='subEnd2' />    </subProcess>    <sequenceFlow id='flow2' sourceRef='mySubProcess' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String TWO_PARALLEL_SUBPROCESSES = "<definitions>  <process id='twoParallelSubProcesses'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='subProcess1' />    <sequenceFlow id='flow2' sourceRef='theStart' targetRef='subProcess2' />    <subProcess id='subProcess1'>      <startEvent id='subProcessStart1' />      <sequenceFlow id='subFlow1' sourceRef='subProcessStart1' targetRef='subTask1' />      <userTask id='subTask1' name='importantTask' />      <sequenceFlow id='subFlow2' sourceRef='subTask1' targetRef='subEnd1' />      <endEvent id='subEnd1' />    </subProcess>    <subProcess id='subProcess2'>      <startEvent id='subProcessStart2' />      <sequenceFlow id='subFlow3' sourceRef='subProcessStart2' targetRef='subTask2' />      <userTask id='subTask2' name='evenMoreImportantTask' />      <sequenceFlow id='subFlow4' sourceRef='subTask2' targetRef='subEnd2' />      <endEvent id='subEnd2' />      <startEvent id='subProcessStart3' />      <sequenceFlow id='subFlow5' sourceRef='subProcessStart3' targetRef='subTask3' />      <userTask id='subTask3' name='possiblyTheMostImportantTask' />      <sequenceFlow id='subFlow6' sourceRef='subTask3' targetRef='subEnd3' />      <endEvent id='subEnd3' />    </subProcess>    <sequenceFlow id='flow3' sourceRef='subProcess1' targetRef='taskAfterSubProcess1' />    <userTask id='taskAfterSubProcess1' name='taskAfterSubProcess1' />    <sequenceFlow id='flow5' sourceRef='taskAfterSubProcess1' targetRef='theEnd' />    <sequenceFlow id='flow4' sourceRef='subProcess2' targetRef='taskAfterSubProcess2' />    <userTask id='taskAfterSubProcess2' name='taskAfterSubProcess2' />    <sequenceFlow id='flow5' sourceRef='taskAfterSubProcess2' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String NESTED_SUBPROCESS = "<definitions>  <process id='nestedSubProcess'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='mySubProcess' />    <subProcess id='mySubProcess'>      <startEvent id='subProcessStart1' />      <sequenceFlow id='subFlow1' sourceRef='subProcessStart1' targetRef='subTask1' />      <userTask id='subTask1' name='task1' />      <sequenceFlow id='subFlow2' sourceRef='subTask1' targetRef='subEnd1' />      <endEvent id='subEnd1' />        <startEvent id='subProcessStart2' />        <sequenceFlow id='subFlow3' sourceRef='subProcessStart2' targetRef='nestedSubProcess' />      <subProcess id='nestedSubProcess'>        <userTask id='subTask3' name='task2' />        <sequenceFlow id='subFlow4' sourceRef='subTask3' targetRef='subTask4' />        <userTask id='subTask4' name='task3' />        <sequenceFlow id='subFlow5' sourceRef='subTask4' targetRef='nestedEnd' />        <endEvent id='nestedEnd' />      </subProcess>      <sequenceFlow id='subFlow6' sourceRef='nestedSubProcess' targetRef='subEnd2' />      <endEvent id='subEnd2' />    </subProcess>    <sequenceFlow id='flow3' sourceRef='mySubProcess' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String SUBPROCESS_WITH_UNJOINED_PATHS = "<definitions>  <process id='unjoinedPaths'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='mySubProcess' />    <subProcess id='mySubProcess'>      <startEvent id='subProcessStart' />      <sequenceFlow id='subFlow1' sourceRef='subProcessStart' targetRef='splitInSubProcess' />      <parallelGateway id='splitInSubProcess' />      <sequenceFlow id='subFlow2' sourceRef='splitInSubProcess' targetRef='subTask1' />      <sequenceFlow id='subFlow3' sourceRef='splitInSubProcess' targetRef='subTask2' />      <sequenceFlow id='subFlow4' sourceRef='splitInSubProcess' targetRef='subTask3' />      <userTask id='subTask1' name='firstTask' />      <userTask id='subTask2' name='secondTask' />      <userTask id='subTask3' name='thirdTask' />      <sequenceFlow id='subFlow4' sourceRef='subTask1' targetRef='subEnd1' />      <endEvent id='subEnd1' />      <sequenceFlow id='subFlow5' sourceRef='subTask2' targetRef='subEnd2' />      <endEvent id='subEnd2' />      <sequenceFlow id='subFlow6' sourceRef='subTask3' targetRef='subEnd3' />      <endEvent id='subEnd3' />    </subProcess>    <sequenceFlow id='flow2' sourceRef='mySubProcess' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";

    public void testSimpleSubProcess() {
        this.deployBpmn2XmlString(SIMPLE_SUBPROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("simpleSubProcess");
        Task task = this.taskService.createTaskQuery().uniqueResult();
        SubProcessTest.assertEquals((String)"importantTask", (String)task.getName());
        this.taskService.completeTask(task.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testSimpleParallelSubProcess() {
        this.deployBpmn2XmlString(SIMPLE_PARALLEL_SUBPROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("simpleParallelSubProcess");
        TaskQuery query = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).orderAsc("name");
        List tasks = query.list();
        SubProcessTest.assertEquals((int)2, (int)tasks.size());
        SubProcessTest.assertEquals((String)"importantTask1", (String)((Task)tasks.get(0)).getName());
        SubProcessTest.assertEquals((String)"importantTask2", (String)((Task)tasks.get(1)).getName());
        this.taskService.completeTask(((Task)tasks.get(0)).getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        CollectionAssertions.assertContainsSameElements((Collection)processInstance.findActiveActivityNames(), (Object[])new String[]{"subTask2"});
        this.taskService.completeTask(((Task)tasks.get(1)).getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testTwoParallelSubProcesses() {
        this.deployBpmn2XmlString(TWO_PARALLEL_SUBPROCESSES);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("twoParallelSubProcesses");
        TaskQuery query = this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderAsc("name");
        List tasks = query.list();
        SubProcessTest.assertEquals((int)3, (int)tasks.size());
        SubProcessTest.assertEquals((String)"evenMoreImportantTask", (String)((Task)tasks.get(0)).getName());
        SubProcessTest.assertEquals((String)"importantTask", (String)((Task)tasks.get(1)).getName());
        SubProcessTest.assertEquals((String)"possiblyTheMostImportantTask", (String)((Task)tasks.get(2)).getName());
        this.taskService.completeTask(((Task)tasks.get(0)).getId());
        pi = this.executionService.findProcessInstanceById(pi.getId());
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), (Object[])new String[]{"subTask1", "subTask3"});
        this.taskService.completeTask(((Task)tasks.get(2)).getId());
        pi = this.executionService.findProcessInstanceById(pi.getId());
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), (Object[])new String[]{"subTask1", "taskAfterSubProcess2"});
        this.taskService.completeTask(((Task)tasks.get(1)).getId());
        pi = this.executionService.findProcessInstanceById(pi.getId());
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), (Object[])new String[]{"taskAfterSubProcess1", "taskAfterSubProcess2"});
        tasks = query.list();
        SubProcessTest.assertEquals((int)2, (int)tasks.size());
        this.taskService.completeTask(((Task)tasks.get(0)).getId());
        this.assertProcessInstanceActive(pi);
        this.taskService.completeTask(((Task)tasks.get(1)).getId());
        this.assertProcessInstanceEnded(pi);
    }

    public void testNestedSubProcess() {
        this.deployBpmn2XmlString(NESTED_SUBPROCESS);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("nestedSubProcess");
        TaskQuery query = this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderAsc("name");
        List tasks = query.list();
        SubProcessTest.assertEquals((int)2, (int)tasks.size());
        SubProcessTest.assertEquals((String)"task1", (String)((Task)tasks.get(0)).getName());
        SubProcessTest.assertEquals((String)"task2", (String)((Task)tasks.get(1)).getName());
        this.taskService.completeTask(((Task)tasks.get(1)).getId());
        tasks = query.list();
        SubProcessTest.assertEquals((int)2, (int)tasks.size());
        SubProcessTest.assertEquals((String)"task1", (String)((Task)tasks.get(0)).getName());
        SubProcessTest.assertEquals((String)"task3", (String)((Task)tasks.get(1)).getName());
        this.taskService.completeTask(((Task)tasks.get(1)).getId());
        tasks = query.list();
        SubProcessTest.assertEquals((int)1, (int)tasks.size());
        SubProcessTest.assertEquals((String)"task1", (String)((Task)tasks.get(0)).getName());
        pi = this.executionService.findProcessInstanceById(pi.getId());
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), (Object[])new String[]{"subTask1"});
        this.taskService.completeTask(((Task)tasks.get(0)).getId());
        this.assertProcessInstanceEnded(pi);
    }

    public void testSubProcessWithUnjoinedPaths() {
        this.deployBpmn2XmlString(SUBPROCESS_WITH_UNJOINED_PATHS);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("unjoinedPaths");
        TaskQuery query = this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderAsc("name");
        List tasks = query.list();
        SubProcessTest.assertEquals((int)3, (int)tasks.size());
        SubProcessTest.assertEquals((String)"firstTask", (String)((Task)tasks.get(0)).getName());
        SubProcessTest.assertEquals((String)"secondTask", (String)((Task)tasks.get(1)).getName());
        SubProcessTest.assertEquals((String)"thirdTask", (String)((Task)tasks.get(2)).getName());
        this.taskService.completeTask(((Task)tasks.get(0)).getId());
        this.taskService.completeTask(((Task)tasks.get(1)).getId());
        this.taskService.completeTask(((Task)tasks.get(2)).getId());
        this.assertProcessInstanceEnded(pi);
    }
}

