/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.test.gateway;

import java.util.Arrays;
import java.util.Collection;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.CollectionAssertions;

public class ParallelGatewayMergeTest
extends JbpmTestCase {
    private static final String TEST_SIMPLE_MERGE_PROCESS = "<definitions>  <process id='simpleMerge'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='parallelGateway' />    <sequenceFlow id='flow2' sourceRef='theStart' targetRef='parallelGateway' />    <sequenceFlow id='flow3' sourceRef='theStart' targetRef='parallelGateway' />    <parallelGateway id='parallelGateway' />    <sequenceFlow id='flow4' sourceRef='parallelGateway' targetRef='wait1' />    <sequenceFlow id='flow5' sourceRef='parallelGateway' targetRef='wait2' />    <receiveTask id='wait1' />    <sequenceFlow id='flow6' sourceRef='wait1' targetRef='theEnd' />    <receiveTask id='wait2' />    <sequenceFlow id='flow7' sourceRef='wait2' targetRef='theEnd' />    <endEvent id='theEnd' >      <terminateEventDefinition/>    </endEvent>  </process></definitions>";
    private static final String TEST_NESTED_MERGE_PROCESS = "<definitions>  <process id='nestedMerge'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='outerFork' />    <parallelGateway id='outerFork' />    <sequenceFlow id='flow2' sourceRef='outerFork' targetRef='innerJoin' />    <sequenceFlow id='flow3' sourceRef='outerFork' targetRef='innerJoin' />    <sequenceFlow id='flow4' sourceRef='outerFork' targetRef='wait1' />    <receiveTask id='wait1' />    <sequenceFlow id='flow5' sourceRef='wait1' targetRef='outerJoin' />    <parallelGateway id='innerJoin' />    <sequenceFlow id='flow6' sourceRef='innerJoin' targetRef='wait2' />    <receiveTask id='wait2' />    <sequenceFlow id='flow7' sourceRef='wait2' targetRef='outerJoin' />    <parallelGateway id='outerJoin' />    <sequenceFlow id='flow8' sourceRef='outerJoin' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String TEST_NESTED_MERGE_PROCESS_2 = "<definitions>  <process id='nestedMerge2' >    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='outerFork' />    <parallelGateway id='outerFork' />    <sequenceFlow id='flow2' sourceRef='outerFork' targetRef='wait' />    <sequenceFlow id='flow3' sourceRef='outerFork' targetRef='innerJoin' />    <sequenceFlow id='flow4' sourceRef='outerFork' targetRef='innerJoin' />    <receiveTask id='wait' />    <sequenceFlow id='flow5' sourceRef='wait' targetRef='outerJoin' />    <parallelGateway id='innerJoin' />    <sequenceFlow id='flow6' sourceRef='innerJoin' targetRef='outerJoin' />    <sequenceFlow id='flow7' sourceRef='innerJoin' targetRef='outerJoin' />    <sequenceFlow id='flow8' sourceRef='innerJoin' targetRef='outerJoin' />    <parallelGateway id='outerJoin' />    <sequenceFlow id='flow10' sourceRef='outerJoin' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";

    public void testSimpleParallelMerge() {
        this.deployBpmn2XmlString(TEST_SIMPLE_MERGE_PROCESS);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("simpleMerge");
        pi.findActiveActivityNames();
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), Arrays.asList("wait1", "wait2"));
    }

    public void testNestedParallelMerge() {
        this.deployBpmn2XmlString(TEST_NESTED_MERGE_PROCESS);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("nestedMerge");
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), Arrays.asList("wait1", "wait2"));
        this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait1").getId());
        this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait2").getId());
        this.assertProcessInstanceEnded(pi);
    }

    public void testNestedParallelMerge2() {
        this.deployBpmn2XmlString(TEST_NESTED_MERGE_PROCESS_2);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("nestedMerge2");
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), Arrays.asList("wait"));
        this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait").getId());
        this.assertProcessInstanceEnded(pi);
    }
}

