/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.processengine;

import org.jbpm.api.ProcessEngine;
import org.jbpm.pvm.internal.cfg.ConfigurationImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringHelper
implements ApplicationContextAware,
DisposableBean {
    protected ApplicationContext applicationContext;
    protected String jbpmCfg = "jbpm.cfg.xml";
    protected ProcessEngine processEngine;

    public void setJbpmCfg(String jbpmCfg) {
        this.jbpmCfg = jbpmCfg;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ProcessEngine createProcessEngine() {
        this.processEngine = new ConfigurationImpl().springInitiated(this.applicationContext).setResource(this.jbpmCfg).buildProcessEngine();
        return this.processEngine;
    }

    public void destroy() throws Exception {
        if (this.processEngine != null) {
            this.processEngine.close();
            this.processEngine = null;
        }
    }
}

