/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.migration;

import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.model.Activity;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.ProcessInstanceMigration;
import org.jbpm.pvm.internal.migration.MigrationDescriptor;
import org.jbpm.pvm.internal.migration.MigrationHandler;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;

public class DefaultMigrationHandler
implements MigrationHandler {
    public void migrateInstance(ProcessDefinition newProcessDefinition, ProcessInstance processInstance, MigrationDescriptor migrationDescriptor) {
        this.migrateExecutions(newProcessDefinition, processInstance, migrationDescriptor);
        DefaultMigrationHandler.logMigration(processInstance, newProcessDefinition);
    }

    private void migrateChildExecutions(ProcessDefinition processDefinition, Execution execution, MigrationDescriptor migrationDescriptor) {
        for (Execution execution2 : execution.getExecutions()) {
            this.migrateExecutions(processDefinition, execution2, migrationDescriptor);
        }
    }

    private void migrateExecutions(ProcessDefinition processDefinition, Execution execution, MigrationDescriptor migrationDescriptor) {
        ActivityImpl newActivity;
        this.migrateChildExecutions(processDefinition, execution, migrationDescriptor);
        if (!(execution instanceof ExecutionImpl) || !(processDefinition instanceof ProcessDefinitionImpl)) {
            return;
        }
        ((ExecutionImpl)execution).setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        String oldName = ((ExecutionImpl)execution).getActivityName();
        if (oldName == null) {
            return;
        }
        String newName = migrationDescriptor.getNewName("org.jbpm.pvm.internal.migration.activity", oldName);
        if (newName == null) {
            newName = oldName;
        }
        if ((newActivity = ((ProcessDefinitionImpl)processDefinition).getActivity(newName)) == null) {
            throw new JbpmException("the activity " + newActivity + " could not be found in the new process definition.");
        }
        ((ExecutionImpl)execution).setActivity((Activity)newActivity);
    }

    private static void logMigration(ProcessInstance processInstance, ProcessDefinition processDefinition) {
        ProcessInstanceMigration processInstanceMigrate = new ProcessInstanceMigration(processInstance, processDefinition);
        HistoryEvent.fire(processInstanceMigrate);
    }
}

