/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.history.model.HistoryTaskImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTaskCmd
extends AbstractCommand<Void> {
    private static final long serialVersionUID = 1L;
    protected long taskDbid;
    protected String reason;
    protected boolean deleteHistory = false;

    public DeleteTaskCmd(String taskId) {
        this.taskDbid = Long.parseLong(taskId);
    }

    public DeleteTaskCmd(String taskId, String reason) {
        this.taskDbid = Long.parseLong(taskId);
        this.reason = reason;
    }

    public DeleteTaskCmd(String taskId, boolean deleteHistory) {
        this.taskDbid = Long.parseLong(taskId);
        this.deleteHistory = deleteHistory;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        DbSession dbSession = environment.get(DbSession.class);
        TaskImpl task = dbSession.get(TaskImpl.class, this.taskDbid);
        if (task != null) {
            HistoryTaskImpl historyTask;
            task.delete(this.reason);
            dbSession.delete(task);
            if (this.deleteHistory && (historyTask = dbSession.get(HistoryTaskImpl.class, this.taskDbid)) != null) {
                dbSession.delete(historyTask);
            }
        } else {
            throw new JbpmException("task " + this.taskDbid + " doesn't exist");
        }
        return null;
    }
}

