/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cfg;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.api.Configuration;
import org.jbpm.api.ProcessEngine;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cfg.ConfigurationParser;
import org.jbpm.pvm.internal.processengine.ProcessEngineImpl;
import org.jbpm.pvm.internal.processengine.SpringProcessEngine;
import org.jbpm.pvm.internal.stream.FileStreamInput;
import org.jbpm.pvm.internal.stream.InputStreamInput;
import org.jbpm.pvm.internal.stream.ResourceStreamInput;
import org.jbpm.pvm.internal.stream.StreamInput;
import org.jbpm.pvm.internal.stream.StringStreamInput;
import org.jbpm.pvm.internal.stream.UrlStreamInput;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;

public class ConfigurationImpl
extends Configuration {
    public static final String DEFAULT_CONFIG_RESOURCENAME = "jbpm.cfg.xml";
    private static Log log = Log.getLog(ConfigurationImpl.class.getName());
    protected transient boolean isConfigured = false;
    transient String jndiName;
    transient boolean checkDb = true;
    transient boolean isSpringEnabled = false;
    transient Object applicationContext = null;
    transient WireContext processEngineWireContext = new WireContext(new WireDefinition(), "process-engine", true);
    transient WireDefinition transactionWireDefinition = new WireDefinition();
    transient ProcessEngine producedProcessEngine;

    public ConfigurationImpl() {
        super(null);
    }

    public ProcessEngine buildProcessEngine() {
        if (!this.isConfigured) {
            this.setResource(DEFAULT_CONFIG_RESOURCENAME);
        }
        if (this.jndiName != null) {
            try {
                InitialContext initialContext = new InitialContext();
                ProcessEngineImpl existing = (ProcessEngineImpl)initialContext.lookup(this.jndiName);
                if (existing != null) {
                    log.debug("found existing process engine under " + this.jndiName);
                    return existing;
                }
            }
            catch (NamingException e) {
                log.debug("jndi name " + this.jndiName + " is not bound");
            }
        }
        if (this.isSpringEnabled) {
            return SpringProcessEngine.create(this);
        }
        return this.instantiateProcessEngine();
    }

    protected ProcessEngine instantiateProcessEngine() {
        return new ProcessEngineImpl(this);
    }

    public ConfigurationImpl setHibernateSessionFactory(Object hibernateSessionFactory) {
        this.processEngineWireContext.getWireDefinition().addDescriptor(new ProvidedObjectDescriptor(hibernateSessionFactory, true));
        return this;
    }

    public ConfigurationImpl setInputStream(InputStream inputStream) {
        this.parse(new InputStreamInput(inputStream));
        return this;
    }

    public ConfigurationImpl setResource(String resource) {
        this.parse(new ResourceStreamInput(resource, this.getClassLoader()));
        return this;
    }

    public ConfigurationImpl setUrl(URL url) {
        this.parse(new UrlStreamInput(url));
        return this;
    }

    public ConfigurationImpl setFile(File file) {
        this.parse(new FileStreamInput(file));
        return this;
    }

    public ConfigurationImpl setXmlString(String xmlString) {
        this.parse(new StringStreamInput(xmlString));
        return this;
    }

    protected void parse(StreamInput streamSource) {
        this.isConfigured = true;
        ConfigurationParser.getInstance().createParse().contextStackPush(this).setStreamSource(streamSource).execute().checkErrors("jbpm configuration " + streamSource);
    }

    public ConfigurationImpl skipDbCheck() {
        this.checkDb = false;
        return this;
    }

    public ConfigurationImpl jndiName(String jndiName) {
        this.jndiName = jndiName;
        return this;
    }

    public ConfigurationImpl springInitiated(Object applicationContext) {
        this.isSpringEnabled = true;
        this.applicationContext = applicationContext;
        return this;
    }

    public ConfigurationImpl springEnabled() {
        this.isSpringEnabled = true;
        return this;
    }

    public ConfigurationImpl jndi(String jndiName) {
        this.jndiName = jndiName;
        return this;
    }

    public boolean isInstantiatedFromSpring() {
        return this.applicationContext != null;
    }

    public WireContext getProcessEngineWireContext() {
        return this.processEngineWireContext;
    }

    public WireDefinition getTransactionWireDefinition() {
        return this.transactionWireDefinition;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public boolean isCheckDb() {
        return this.checkDb;
    }

    public ProcessEngine getProducedProcessEngine() {
        return this.producedProcessEngine;
    }

    public void setProducedProcessEngine(ProcessEngineImpl processEngine) {
        this.producedProcessEngine = processEngine;
    }

    public Object getApplicationContext() {
        return this.applicationContext;
    }
}

