/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.List;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.model.Transition;
import org.jbpm.jpdl.internal.activity.JpdlExternalActivity;
import org.jbpm.pvm.internal.cal.Duration;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.TaskActivityStart;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.task.SwimlaneDefinitionImpl;
import org.jbpm.pvm.internal.task.SwimlaneImpl;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskActivity
extends JpdlExternalActivity {
    private static final long serialVersionUID = 1L;
    protected TaskDefinitionImpl taskDefinition;

    @Override
    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    public void execute(ExecutionImpl execution) {
        DbSession dbSession = EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl task = dbSession.createTask();
        task.setTaskDefinition(this.taskDefinition);
        task.setExecution(execution);
        task.setProcessInstance(execution.getProcessInstance());
        task.setSignalling(true);
        if (this.taskDefinition.getName() != null) {
            task.setName(this.taskDefinition.getName());
        } else {
            task.setName(execution.getActivityName());
        }
        Expression descriptionExpression = this.taskDefinition.getDescription();
        if (descriptionExpression != null) {
            String description = (String)descriptionExpression.evaluate(task);
            task.setDescription(description);
        }
        task.setPriority(this.taskDefinition.getPriority());
        task.setFormResourceName(this.taskDefinition.getFormResourceName());
        String dueDateDescription = this.taskDefinition.getDueDateDescription();
        if (dueDateDescription != null) {
            task.setDuedate(Duration.calculateDueDate(dueDateDescription));
        }
        dbSession.save(task);
        SwimlaneDefinitionImpl swimlaneDefinition = this.taskDefinition.getSwimlaneDefinition();
        if (swimlaneDefinition != null) {
            SwimlaneImpl swimlane = execution.getInitializedSwimlane(swimlaneDefinition);
            task.setSwimlane(swimlane);
            task.setAssignee(swimlane.getAssignee());
            for (ParticipationImpl participant : swimlane.getParticipations()) {
                task.addParticipation(participant.getUserId(), participant.getGroupId(), participant.getType());
            }
        }
        execution.initializeAssignments(this.taskDefinition, task);
        HistoryEvent.fire(new TaskActivityStart(task), execution);
        execution.waitForSignal();
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
        this.signal((ExecutionImpl)execution, signalName, parameters);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void signal(ExecutionImpl execution, String signalName, Map<String, ?> parameters) throws Exception {
        void var7_12;
        void var7_10;
        ActivityImpl activity = execution.getActivity();
        if (parameters != null) {
            execution.setVariables(parameters);
        }
        execution.fire(signalName, activity);
        DbSession taskDbSession = EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl task = taskDbSession.findTaskByExecution(execution);
        if (task != null) {
            task.setSignalling(false);
        }
        Object var7_7 = null;
        List<? extends Transition> outgoingTransitions = activity.getOutgoingTransitions();
        if (outgoingTransitions == null || outgoingTransitions.isEmpty()) return;
        boolean noOutcomeSpecified = "jbpm_no_task_outcome_specified_jbpm".equals(signalName);
        if (noOutcomeSpecified && activity.findOutgoingTransition(signalName) == null) {
            TransitionImpl transitionImpl = activity.findOutgoingTransition(null);
        } else {
            TransitionImpl transitionImpl = activity.findOutgoingTransition(signalName);
        }
        if (var7_10 == null) {
            if (signalName == null) {
                throw new JbpmException("No unnamed transitions were found for the task '" + this.getTaskDefinition().getName() + "'");
            }
            if (!noOutcomeSpecified) throw new JbpmException("No transition named '" + signalName + "' was found.");
            if (outgoingTransitions.size() != 1) throw new JbpmException("No unnamed transitions were found for the task '" + this.getTaskDefinition().getName() + "'");
            Transition transition = outgoingTransitions.get(0);
        }
        if (task != null && !task.isCompleted()) {
            task.skip(var7_12.getName());
        }
        if (var7_12 == null) return;
        execution.take((Transition)var7_12);
    }

    public TaskDefinitionImpl getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setTaskDefinition(TaskDefinitionImpl taskDefinition) {
        this.taskDefinition = taskDefinition;
    }
}

