/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.model.Activity;
import org.jbpm.api.model.Transition;
import org.jbpm.jpdl.internal.activity.JpdlExternalActivity;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupActivity
extends JpdlExternalActivity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    public void execute(ExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        List<Activity> startActivities = this.findStartActivities(activity);
        if (startActivities.size() == 1) {
            execution.execute(startActivities.get(0));
        } else {
            ExecutionImpl concurrentRoot = null;
            if ("active-root".equals(execution.getState())) {
                concurrentRoot = execution;
            } else if ("active-concurrent".equals(execution.getState())) {
                concurrentRoot = execution.getParent();
            } else {
                throw new JbpmException("illegal state");
            }
            for (Activity startActivity : startActivities) {
                ExecutionImpl concurrentExecution = concurrentRoot.createExecution();
                concurrentExecution.setState("active-concurrent");
                concurrentExecution.execute(startActivity);
            }
        }
    }

    private List<Activity> findStartActivities(Activity activity) {
        ArrayList<Activity> startActivities = new ArrayList<Activity>();
        List<? extends Activity> nestedActivities = activity.getActivities();
        for (Activity activity2 : nestedActivities) {
            if (activity2.getIncomingTransitions() != null && !activity2.getIncomingTransitions().isEmpty()) continue;
            startActivities.add(activity2);
        }
        return startActivities;
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
        this.signal((ExecutionImpl)execution, signalName, parameters);
    }

    public void signal(ExecutionImpl execution, String signalName, Map<String, ?> parameters) throws Exception {
        Transition transition = null;
        ActivityImpl activity = execution.getActivity();
        List<? extends Transition> outgoingTransitions = activity.getOutgoingTransitions();
        int nbrOfOutgoingTransitions = outgoingTransitions != null ? outgoingTransitions.size() : 0;
        transition = signalName == null && nbrOfOutgoingTransitions == 1 ? outgoingTransitions.get(0) : activity.getOutgoingTransition(signalName);
        execution.take(transition);
    }
}

